#include <util/stream/output.h>
#include <library/cpp/string_utils/url/url.h>

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/getopt/last_getopt.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/owners.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"
#include "merge_turbo_sources.h"
#include "process_turbo_logs.h"
#include "process_turbo_bans.h"

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);
    using namespace NWebmaster;
    using namespace NWebmaster::NTurbo;

    TModChooser modChooser;
    modChooser.AddMode("ProcessTurboLogs", ProcessTurboLogs, "ProcessTurboLogs");
    modChooser.AddMode("ProcessTurboApiLogs", ProcessTurboApiLogs, "ProcessTurboApiLogs");
    modChooser.AddMode("ProcessTurboBans", ProcessTurboBans, "ProcessTurboBans");
    modChooser.AddMode("MergeTurboSources", MergeTurboSources, "MergeTurboSources");

    return modChooser.Run(argc, argv);
}

