#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>

#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/wmcutil/config_base.h>

namespace NWebmaster {
namespace NTurbo {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        const TProdYTEnvironment prodEnv;
        MR_TURBO_SERVER_HOST                 = "hahn.yt.yandex.net";
        MR_JUPITER_SERVER_HOST               = "arnold.yt.yandex.net";

        TABLE_HISTORY_STATIC                 = "//home/turborss/production/yt_pull_job/history_static";
        TABLE_WORK_ROOT                      = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "import/turbo");
        TABLE_TURBO_URLS                     = NYTUtils::JoinPath(TABLE_WORK_ROOT, "turbo_search_urls");
        TABLE_TURBO_URLS_STATS               = NYTUtils::JoinPath(TABLE_WORK_ROOT, "turbo_stats");
        TABLE_TURBO_URLS_SEARCH_STATS        = NYTUtils::JoinPath(TABLE_WORK_ROOT, "turbo_searchurls_stats");
        TABLE_TURBO_URLS_SEARCH_SAMPLES      = NYTUtils::JoinPath(TABLE_WORK_ROOT, "turbo_searchurls_samples");
    }

public:
    TString MR_TURBO_SERVER_HOST;
    TString MR_JUPITER_SERVER_HOST;
    TString TABLE_HISTORY_STATIC;
    TString TABLE_WORK_ROOT;
    TString TABLE_TURBO_URLS;
    TString TABLE_TURBO_URLS_STATS;
    TString TABLE_TURBO_URLS_SEARCH_STATS;
    TString TABLE_TURBO_URLS_SEARCH_SAMPLES;
};

} //namespace NTurbo
} //namespace NWebmaster
