#include <util/stream/output.h>
#include <library/cpp/string_utils/url/url.h>

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/getopt/last_getopt.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/owners.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"
#include "stats.h"

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);
    using namespace NWebmaster;
    using namespace NWebmaster::NTurbo;

    TModChooser modChooser;
    modChooser.AddMode("ProcessTurboStats", ProcessTurboStats, "ProcessTurboStats");
    modChooser.AddMode("ProcessSearchTurboStats", ProcessSearchTurboStats, "ProcessSearchTurboStats");

    return modChooser.Run(argc, argv);
}

