use hahn;
PRAGMA yt.Pool = 'robot-webmaster';
PRAGMA yson.DisableStrict;
$select_result = (
    SELECT
        Url::CutWWW2(Url::GetHost(hs.`key`)) as domain,
        hs.`key` as url,
        DateTime::FromSeconds(Cast(Yson::ConvertToUint64(hs.meta.ts) as uint32)) as start_date,
        DateTime::FromSeconds(Cast(Yson::ConvertToUint64(hs.meta.pull_ts) as uint32)) as update_date,
        Yson::LookupString(Yson::YPath(Yson::ParseJson(hs.value),'/attrs/body/0'),'title') as title--,
    FROM `//home/turborss/production/yt_pull_job/history_static` as hs
        left join `//home/webmaster/prod/turbo/cmnt/total_url_with_cmnt` as tuwc on hs.`key` = tuwc.url
    where Yson::ConvertToBool(meta.cmnt.has_cmnt) and tuwc.url is null
);
insert into `//home/webmaster/prod/turbo/cmnt/total_url_with_cmnt`
select * from $select_result
order by domain, start_date, url;

$output = '//home/webmaster/prod/turbo/cmnt/increment_' || Cast(CurrentUtcTimestamp() as String);
insert into $output
select * from $select_result
order by domain, start_date, url;


