ENV="prod"
EXPORT_CATALOGIA="user_sessions/exports/catalogia/catalogia -E ${ENV}"
PARSER="user_sessions/parser/parser"
REPORTS="user_sessions/reports/reports -E ${ENV}"
NICHE="user_sessions/niche/miner/miner -E ${ENV}"
NICHE2="user_sessions/niche2/preparation/preparation -E ${ENV}"
YQL="yql --syntax-version=1"

_scenario() {
    MAIN    exports_catalogia_hosts:
    MAIN    exports_catalogia_robots:           exports_catalogia_hosts
    MAIN    exports_catalogia_mirrors:          exports_catalogia_hosts
    MAIN    exports_catalogia_queries2:         exports_catalogia_mirrors exports_catalogia_robots   restart_on_success="0 0 * * 1,3,5,7" retry_on_failure="15 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    exports_catalogia_internal_links:   restart_on_success="0 0 * * 2,4,6" retry_on_failure="15 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru

    #MAIN    exports_catalogia_wm_clusters_extract:
    #MAIN    exports_catalogia_wm_clusters_group:            exports_catalogia_wm_clusters_extract
    #MAIN    exports_catalogia_wm_clusters_generate_base:    exports_catalogia_wm_clusters_group
    #MAIN    exports_catalogia_wm_clusters_generate_shard:   exports_catalogia_wm_clusters_generate_base
    #MAIN    exports_catalogia_wm_clusters_content_shard:    exports_catalogia_wm_clusters_generate_shard
    #MAIN    exports_catalogia_wm_clusters_content_merge:    exports_catalogia_wm_clusters_content_shard     restart_on_success="0 3 */16 * *" retry_on_failure="15 3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru

    MAIN    user_sessions_parser_robots:                                 restart_on_success="*/10 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    user_sessions_parser_fast:                                   restart_on_success="*/10 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru

    MAIN    user_sessions_parser_daily:      user_sessions_parser_robots
    MAIN    user_sessions_parser_sync:       user_sessions_parser_daily
    MAIN    user_sessions_parser_monitoring: user_sessions_parser_sync    restart_on_success="*/10 * * * *" retry_on_failure="45 */8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru

    MAIN    user_sessions_reports_update_geodata:   restart_on_success="30 */12 * * *"
    MAIN    user_sessions_reports_update_hosts:     user_sessions_reports_update_geodata
    MAIN    user_sessions_reports_last_queries:     user_sessions_reports_update_hosts
    MAIN    user_sessions_reports_top_queries:      user_sessions_reports_update_hosts
    MAIN    user_sessions_reports_top_urls:         user_sessions_reports_update_hosts
    MAIN    user_sessions_reports_archives:         user_sessions_reports_last_queries
    MAIN    user_sessions_reports_groups:           restart_on_success="45 */2 * * *"
    MAIN    user_sessions_reports_trends_snapshot:
    MAIN    user_sessions_reports_trends:           user_sessions_reports_trends_snapshot

    MAIN    user_sessions_reports_update:           user_sessions_reports_last_queries \
                                                    user_sessions_reports_top_queries \
                                                    user_sessions_reports_top_urls \
                                                    user_sessions_reports_groups \
                                                    user_sessions_reports_archives \
                                                    user_sessions_reports_trends \
                                                        restart_on_success="*/30 * * * *" \
                                                        retry_on_failure="40 */12 * * *" \
                                                        mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru

    MAIN    user_sessions_reports_testing:          user_sessions_reports_update

    # MAIN    niche_prepare_queries :
    # MAIN    niche_import_queries_and_rivals : niche_prepare_queries restart_on_success="15 * * * *" retry_on_failure="40 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru

    MAIN    niche2_source_get_static_groups : restart_on_success="15 */10 * * *" retry_on_failure="40 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru

    MAIN    niche2_apply_hash_to_clusters: restart_on_success="0 0 * * 1" retry_on_failure="30 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    niche2_get_cluster_names: niche2_apply_hash_to_clusters restart_on_success="0 1 * * 1" retry_on_failure="20 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    niche2_prepare_new_markets_rivals: restart_on_success="0 2 * * 1" retry_on_failure="40 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    niche2_prepare_new_markets: restart_on_success="15 * * * *" retry_on_failure="40 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    niche2_prepare_reports: restart_on_success="30 * * * *" retry_on_failure="50 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
}

function exports_catalogia_mirrors {
     ${EXPORT_CATALOGIA} Mirrors
}

function exports_catalogia_hosts {
     ${EXPORT_CATALOGIA} Hosts
}

function exports_catalogia_robots {
     ${EXPORT_CATALOGIA} Robots
}

function exports_catalogia_queries2 {
    ${EXPORT_CATALOGIA} UserSessionsV2
}

function exports_catalogia_internal_links {
    ${EXPORT_CATALOGIA} InternalLinks
}

#function exports_catalogia_wm_clusters_extract {
#    ${EXPORT_CATALOGIA} ClustersExtract
#}

#function exports_catalogia_wm_clusters_group {
#    ${EXPORT_CATALOGIA} ClustersGroup
#}

#function exports_catalogia_wm_clusters_generate_base {
#    ${EXPORT_CATALOGIA} ClustersGenerateBase
#}

#function exports_catalogia_wm_clusters_generate_shard {
#    ${EXPORT_CATALOGIA} ClustersGenerateShard
#}

#function exports_catalogia_wm_clusters_content_shard {
#    ${EXPORT_CATALOGIA} ClustersContentShard
#}

#function exports_catalogia_wm_clusters_content_merge {
#    ${EXPORT_CATALOGIA} ClustersContentMerge
#}

function user_sessions_parser_fast {
    ${PARSER} ParseFast -env-root ${ENV}
}

function user_sessions_parser_daily {
    ${PARSER} ParseDaily --env-root ${ENV}
}

function user_sessions_parser_sync {
    ${PARSER} Sync --env-root ${ENV}
}

function user_sessions_parser_robots {
    ${YQL} -i user_sessions/parser/robots.sql
}

function user_sessions_parser_monitoring {
    ${PARSER} UpdateMonitoring --env-root ${ENV}
}

function user_sessions_reports_update_geodata {
    curl https://proxy.sandbox.yandex-team.ru/last/GEODATA_TREE_LING_STABLE > geodata4-tree+ling.bin
}

function user_sessions_reports_update_hosts {
    ${REPORTS} UpdateHosts
}

function user_sessions_reports_last_queries {
    ${REPORTS} LastQueries
}

function user_sessions_reports_archives {
    ${REPORTS} Archives
}

function user_sessions_reports_top_queries {
    ${REPORTS} TopQueries
}

function user_sessions_reports_top_urls {
    ${REPORTS} TopUrls
}

function user_sessions_reports_groups {
    ${REPORTS} Groups
}

function user_sessions_reports_trends_snapshot {
    ${REPORTS} TrendsSnapshot
}

function user_sessions_reports_trends {
    ${REPORTS} Trends
}

function user_sessions_reports_update {
    echo
}

function user_sessions_reports_testing {
    ${YQL} -i user_sessions/reports/task_testing.sql
    user_sessions/reports/task_testing_attributes.sh
}

# function niche_prepare_queries {
#     ${NICHE} PrepareQueryData
# }

# function niche_import_queries_and_rivals {
#     ${NICHE} ImportQueriesAndRivals
# }

function niche2_source_get_static_groups {
    ${NICHE} SourceFavorites
}

function niche2_get_cluster_names {
    transfer-manager add-task --sync --src-cluster hahn --src-table //home/searchshare/common/clusters --dst-cluster arnold --dst-table //home/webmaster/prod/searchqueries/niche2/clusters/searchshare_clusters
    ${NICHE2} GetClusterNames
}

function niche2_apply_hash_to_clusters {
    transfer-manager add-task --sync --src-cluster hahn --src-table //home/searchshare/common/query_to_cluster --dst-cluster arnold --dst-table //home/webmaster/prod/searchqueries/niche2/clusters/searchshare_query_to_cluster
    # transfer-manager add-task --sync --src-cluster hahn --src-table //home/spikes/long_timeline/raw_table/20200306_20220307 --dst-cluster arnold --dst-table //home/webmaster/prod/searchqueries/niche2/clusters/spikes_query_to_cluster
    ${NICHE2} ApplyHashQueriesInClusters
}

function niche2_prepare_new_markets_rivals {
    ${NICHE2} PrepareRivals
}

function niche2_prepare_new_markets {
    ${NICHE2} PrepareQueries
}

function niche2_prepare_reports {
    ${NICHE2} PrepareReport
}
