#pragma once

#include <util/datetime/base.h>
#include <wmconsole/version3/library/conf/yt.h>

#include <util/generic/singleton.h>

#include <wmconsole/version3/wmcutil/config_base.h>
#include <wmconsole/version3/wmcutil/http_client.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "yt.h"

namespace NWebmaster {

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MONITOR_PERFORMANCE_SUFFIX                      = "production";

        MR_SERVER_HOST_HITLOG                           = "hahn.yt.yandex.net";
        MR_SERVER_HOST_QUERIES                          = "hahn.yt.yandex.net";
        MR_SERVER_HOST_TEXTS                            = "hahn.yt.yandex.net";
        MR_SERVER_HOST_MAIN                             = "arnold.yt.yandex.net";
        MR_SERVER_HOST_USER_SESSIONS                    = "arnold.yt.yandex.net";

        TABLE_EXPORT_ROOT                               = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;
        TABLE_QUERIES_ROOT                              = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "searchqueries");
        TABLE_TEMP_ROOT                                 = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_TEMP_ROOT, "searchqueries");

        TABLE_SOURCE_WEBMASTER_HOSTS                    = "//home/webmaster/prod/export/webmaster-hosts";
        TABLE_SOURCE_QUERIES_CONVERTED_PREFIX           = TCommonYTConfigSQ::CInstance().TABLE_CONVERTED_QUERIES_V4_ROOT;
        TABLE_SOURCE_ADVQ_ROOT                          = "//home/advq/advq/offline_pkz/output/webmaster";
        ADVQ_SUFFIX                                     = "queries_prod";

        TABLE_SOURCE_RADAR_ROOT                         = "//home/radar_top_sites/production/export/domain_markup";
        TABLE_SOURCE_GROUPS_SETTINGS                    = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_USER_ROOT, "query_groups");
        TABLE_SOURCE_USER_URLS                          = TCommonYTConfig::CInstance().TABLE_SOURCE_USER_URLS;

        TABLE_REPORTS_ROOT                              = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "reports_v4");
        TABLE_REPORTS_LAST_QUERIES                      = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "last_queries");
        TABLE_REPORTS_TOP_QUERIES                       = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "top_3month.top");
        TABLE_REPORTS_TOP_URLS                          = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "top_urls");
        TABLE_REPORTS_WEBMASTER_HOSTS                   = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "webmaster-hosts");

        TABLE_REPORTS_GROUPS_ROOT                       = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "groups");
        TABLE_REPORTS_FAVORITE_QUERIES                  = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_queries");
        TABLE_REPORTS_FAVORITE_QUERIES_SETTINGS         = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_queries_settings");
        TABLE_REPORTS_FAVORITE_URLS                     = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_urls");
        TABLE_REPORTS_FAVORITE_URLS_SETTINGS            = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_urls_settings");

        TABLE_TRENDS2_ROOT                              = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "trends_v2");
        TABLE_TRENDS2_INTM                              = NYTUtils::JoinPath(TABLE_TRENDS2_ROOT, "intermediate");
        TABLE_TRENDS2_SNAPSHOT                          = NYTUtils::JoinPath(TABLE_TRENDS2_ROOT, "snapshot");
        TABLE_TRENDS2_TRENDS                            = NYTUtils::JoinPath(TABLE_TRENDS2_ROOT, "trends");
        TABLE_TRENDS2_SNAPSHOT_LOG                      = TABLE_TRENDS2_SNAPSHOT + "-log";

        TABLE_ARCHIVE_INTM_FULL                         = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "archive-intm");
        TABLE_ARCHIVE_INTM_QUERIES                      = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "archive-intm-queries");
        TABLE_ARCHIVE_ROOT                              = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "archives");
        TABLE_ARCHIVE_CLICKS                            = NYTUtils::JoinPath(TABLE_ARCHIVE_ROOT, "clicks");
        TABLE_ARCHIVE_SHOWS                             = NYTUtils::JoinPath(TABLE_ARCHIVE_ROOT, "shows");
        TABLE_ARCHIVE_AVG_POSITION                      = NYTUtils::JoinPath(TABLE_ARCHIVE_ROOT, "avg-position");

        TABLE_RECOMMENDED_SOURCE_HOSTS                  = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "direct-suggest-hosts");
        TABLE_RECOMMENDED_ROOT                          = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "direct");
        TABLE_RECOMMENDED_QUERIES_TO_FORECASTER         = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "offline_pkz", ADVQ_SUFFIX);
        TABLE_RECOMMENDED_QUERIES_FROM_FORECASTER       = NYTUtils::JoinPath(TABLE_SOURCE_ADVQ_ROOT, ADVQ_SUFFIX);

        TABLE_RECOMMENDED_TEMP_ROOT                     = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "recommended");
        TABLE_RECOMMENDED_ENRICHED_GROUPS               = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "enriched_groups");
        TABLE_RECOMMENDED_ENRICHED_QUERIES              = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "enriched_queries");
        TABLE_RECOMMENDED_EXTRACTED_QUERIES             = NYTUtils::JoinPath(TABLE_RECOMMENDED_TEMP_ROOT, "extracted_queries");
        TABLE_RECOMMENDED_EXTRACTED_QUERIES_FILTER      = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "extracted_queries_filter");
        TABLE_RECOMMENDED_FORECASTED_GROUPS             = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "forecasted_groups");
        TABLE_RECOMMENDED_IDS_METADESCRS                = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_metadescrs");
        TABLE_RECOMMENDED_IDS_QUERIES                   = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_queries");
        TABLE_RECOMMENDED_IDS_TITLES                    = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_titles");
        TABLE_RECOMMENDED_IDS_URLS                      = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_urls");
        TABLE_RECOMMENDED_INTM_ENRICHED_GROUPS          = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "intermediate/enriched_groups");
        TABLE_RECOMMENDED_INTM_RAW_GROUPS               = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "intermediate/raw_groups");
        TABLE_RECOMMENDED_SOURCE_HOST2VEC               = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "host2vec");
        TABLE_RECOMMENDED_SOURCE_HOST2VEC_GROUPS        = TABLE_RECOMMENDED_SOURCE_HOST2VEC + ".g";
        TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOST_GROUPS   = TABLE_RECOMMENDED_SOURCE_HOST2VEC + ".hg";
        TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOSTS         = TABLE_RECOMMENDED_SOURCE_HOST2VEC + ".h";
        RECOMMENDED_ENABLED_BUILD_DATA                  = true;

        TABLE_RIVALS_QUERIES_ROOT                       = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "rivals");
        TABLE_RIVALS_QUERIES_HOST2VEC_ROOT              = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_ROOT, "host2vec");
        TABLE_RIVALS_QUERIES_HOST2VEC_HOST2VEC          = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "host2vec");
        TABLE_RIVALS_QUERIES_HOST2VEC_GROUPS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "groups");
        TABLE_RIVALS_QUERIES_HOST2VEC_HOST_GROUPS       = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "host_groups");
        TABLE_RIVALS_QUERIES_HOST2VEC_HOSTS             = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "hosts");
        TABLE_RIVALS_QUERIES_REPORT_ROOT                = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_ROOT, "report");
        TABLE_RIVALS_QUERIES_TMP_ROOT                   = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "rivals");
        TABLE_RIVALS_QUERIES_TMP_EXTRACTED_QUERIES      = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_TMP_ROOT, "queries");
        TABLE_RIVALS_QUERIES_TMP_RAW_GROUPS             = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_TMP_ROOT, "groups");
        TABLE_RIVALS_QUERIES_TMP_HOST_COUNTERS          = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_TMP_ROOT, "host_counters");

        TABLE_RIVALS_QUERIES2_ROOT                      = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "rivals_v2");
        TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT             = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_ROOT, "host2vec");
        TABLE_RIVALS_QUERIES2_HOST2VEC_HOST2VEC         = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "host2vec");
        TABLE_RIVALS_QUERIES2_HOST2VEC_GROUPS           = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "groups");
        TABLE_RIVALS_QUERIES2_HOST2VEC_HOST_GROUPS      = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "host_groups");
        TABLE_RIVALS_QUERIES2_HOST2VEC_HOSTS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "hosts");
        TABLE_RIVALS_QUERIES2_HOST_COUNTERS_ROOT        = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_ROOT, "host_counters");
        TABLE_RIVALS_QUERIES2_REPORT_ROOT               = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_ROOT, "report");
        TABLE_RIVALS_QUERIES2_TMP_ROOT                  = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "rivals_v2");
        TABLE_RIVALS_QUERIES2_TMP_EXTRACTED_QUERIES     = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "queries");
        TABLE_RIVALS_QUERIES2_TMP_RAW_GROUPS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "groups");
        TABLE_RIVALS_QUERIES2_TMP_HOST_COUNTERS         = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "host_counters");
        TABLE_RIVALS_QUERIES2_TMP_DAY_TRENDS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "day_trends");

        TABLE_RECOMMENDED_UC2_QUERIES_FROM_FORECASTER   = NYTUtils::JoinPath(TABLE_SOURCE_ADVQ_ROOT, ADVQ_SUFFIX);
        TABLE_RECOMMENDED_UC2_QUERIES_TO_FORECASTER     = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "offline_pkz", ADVQ_SUFFIX);

        TABLE_RECOMMENDED_UC2_ROOT                      = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "direct", "extended");
        TABLE_RECOMMENDED_UC2_HOSTS_PREPARED            = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "hosts");
        TABLE_RECOMMENDED_UC2_QUERIES_EXTRACTED         = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "extracted");
        TABLE_RECOMMENDED_UC2_QUERIES                   = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "queries");
        TABLE_RECOMMENDED_UC2_QUERIES_FORECASTED        = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "forecasted");
        TABLE_RECOMMENDED_UC2_QUERIES_PREPARED          = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "prepared");
        TABLE_RECOMMENDED_UC2_TMP_ROOT                  = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "direct", "extended");
        TABLE_RECOMMENDED_UC2_URLS                      = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "urls");
    }

public:
    const float OPERATION_WEIGHT = 1.0f;

    static constexpr const char *GEOBASE_FILE_LITE = "geodata4-tree+ling.bin";
    static constexpr const char *FORMAT = "%Y-%m-%d";

    TString YT_ENV;
    TString MR_SERVER_HOST_HITLOG;
    TString MR_SERVER_HOST_TEXTS;
    TString MR_SERVER_HOST_MAIN;
    TString MR_SERVER_HOST_QUERIES;
    TString MR_SERVER_HOST_USER_SESSIONS;

    TString TABLE_TEMP_ROOT;
    TString TABLE_EXPORT_ROOT;

    TString TABLE_SOURCE_WEBMASTER_HOSTS;

    TString TABLE_SOURCE_ADVQ_ROOT;
    TString TABLE_SOURCE_GROUPS_SETTINGS;
    TString TABLE_SOURCE_QUERIES_CONVERTED_PREFIX;
    TString TABLE_SOURCE_USER_URLS;
    TString TABLE_SOURCE_RADAR_ROOT;

    TString TABLE_QUERIES_ROOT;

    TString TABLE_REPORTS_ROOT;
    TString TABLE_REPORTS_FAVORITE_QUERIES;
    TString TABLE_REPORTS_FAVORITE_QUERIES_SETTINGS;
    TString TABLE_REPORTS_FAVORITE_URLS;
    TString TABLE_REPORTS_FAVORITE_URLS_SETTINGS;
    TString TABLE_REPORTS_GROUPS_ROOT;
    TString TABLE_REPORTS_TOP_QUERIES;
    TString TABLE_REPORTS_TOP_URLS;
    TString TABLE_REPORTS_WEBMASTER_HOSTS;
    TString TABLE_REPORTS_LAST_QUERIES;

    TString TABLE_TRENDS2_ROOT;
    TString TABLE_TRENDS2_INTM;
    TString TABLE_TRENDS2_SNAPSHOT;
    TString TABLE_TRENDS2_SNAPSHOT_LOG;
    TString TABLE_TRENDS2_TRENDS;

    TString TABLE_ARCHIVE_INTM_FULL;
    TString TABLE_ARCHIVE_INTM_QUERIES;
    TString TABLE_ARCHIVE_ROOT;
    TString TABLE_ARCHIVE_CLICKS;
    TString TABLE_ARCHIVE_SHOWS;
    TString TABLE_ARCHIVE_AVG_POSITION;
    TString ADVQ_SUFFIX;

    bool RECOMMENDED_ENABLED_BUILD_DATA;
    TString TABLE_RECOMMENDED_ROOT;
    TString TABLE_RECOMMENDED_TEMP_ROOT;
    TString TABLE_RECOMMENDED_ENRICHED_GROUPS;
    TString TABLE_RECOMMENDED_ENRICHED_QUERIES;
    TString TABLE_RECOMMENDED_EXTRACTED_QUERIES_FILTER;
    TString TABLE_RECOMMENDED_EXTRACTED_QUERIES;
    TString TABLE_RECOMMENDED_FORECASTED_GROUPS;
    TString TABLE_RECOMMENDED_IDS_METADESCRS;
    TString TABLE_RECOMMENDED_IDS_QUERIES;
    TString TABLE_RECOMMENDED_IDS_TITLES;
    TString TABLE_RECOMMENDED_IDS_URLS;
    TString TABLE_RECOMMENDED_INTM_ENRICHED_GROUPS;
    TString TABLE_RECOMMENDED_INTM_RAW_GROUPS;
    TString TABLE_RECOMMENDED_QUERIES_FROM_FORECASTER;
    TString TABLE_RECOMMENDED_QUERIES_TO_FORECASTER;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC_GROUPS;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOST_GROUPS;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOSTS;
    TString TABLE_RECOMMENDED_SOURCE_HOSTS;

    TString MONITOR_PERFORMANCE_SUFFIX;

    TString TABLE_RIVALS_QUERIES_ROOT;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_ROOT;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_HOST2VEC;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_GROUPS;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_HOST_GROUPS;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_HOSTS;
    TString TABLE_RIVALS_QUERIES_REPORT_ROOT;
    TString TABLE_RIVALS_QUERIES_TMP_ROOT;
    TString TABLE_RIVALS_QUERIES_TMP_EXTRACTED_QUERIES;
    TString TABLE_RIVALS_QUERIES_TMP_RAW_GROUPS;
    TString TABLE_RIVALS_QUERIES_TMP_HOST_COUNTERS;

    TString TABLE_RIVALS_QUERIES2_ROOT;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_HOST2VEC;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_GROUPS;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_HOST_GROUPS;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_HOSTS;
    TString TABLE_RIVALS_QUERIES2_HOST_COUNTERS_ROOT;
    TString TABLE_RIVALS_QUERIES2_REPORT_ROOT;
    TString TABLE_RIVALS_QUERIES2_TMP_ROOT;
    TString TABLE_RIVALS_QUERIES2_TMP_EXTRACTED_QUERIES;
    TString TABLE_RIVALS_QUERIES2_TMP_RAW_GROUPS;
    TString TABLE_RIVALS_QUERIES2_TMP_HOST_COUNTERS;
    TString TABLE_RIVALS_QUERIES2_TMP_DAY_TRENDS;

    TString TABLE_RECOMMENDED_UC2_QUERIES_FROM_FORECASTER;
    TString TABLE_RECOMMENDED_UC2_QUERIES_TO_FORECASTER;
    TString TABLE_RECOMMENDED_UC2_ROOT;
    TString TABLE_RECOMMENDED_UC2_HOSTS_PREPARED;
    TString TABLE_RECOMMENDED_UC2_QUERIES;
    TString TABLE_RECOMMENDED_UC2_QUERIES_EXTRACTED;
    TString TABLE_RECOMMENDED_UC2_QUERIES_FORECASTED;
    TString TABLE_RECOMMENDED_UC2_QUERIES_PREPARED;
    TString TABLE_RECOMMENDED_UC2_TMP_ROOT;
    TString TABLE_RECOMMENDED_UC2_URLS;
};

} //namespace NWebmaster
