#pragma once

#include <wmconsole/version3/library/env/yt.h>

#include <kernel/yt/utils/yt_utils.h>

#include <util/generic/singleton.h>

namespace NWebmaster {

struct TCommonYTConfigSQ {
    static TCommonYTConfigSQ &Instance() {
        return *Singleton<TCommonYTConfigSQ>();
    }

    static const TCommonYTConfigSQ &CInstance() {
        return Instance();
    }

    TCommonYTConfigSQ() :
        TCommonYTConfigSQ("arnold.yt.yandex.net", "//", TProdYTEnvironment().TABLE_ENV_ROOT)
    {}

    TCommonYTConfigSQ(const TString& ytProxy, const TString& sourcePrefix, const TString& destinationPrefix) {
        const TProdYTEnvironment prodEnv;
        const TProdYTEnvironment custEnv;

        MR_SERVER_HOST_USER_SESSIONS                    = ytProxy;

        TABLE_SOURCE_FRAUD_UID_TYPES_ROOT               = NJupiter::JoinYtPath(sourcePrefix, "home/antifraud/export/uid_types/daily");

        TABLE_SOURCE_METRIKA_HIT_LOG_ROOT               = NJupiter::JoinYtPath(sourcePrefix, "logs/hit-log/1d");
        TABLE_SOURCE_METRIKA_HIT_PRIVATE_LOG_ROOT       = NJupiter::JoinYtPath(sourcePrefix, "logs/hit-private-log/1d");
        TABLE_SOURCE_METRIKA_VISIT_LOG_ROOT             = NJupiter::JoinYtPath(sourcePrefix, "logs/visit-v2-log/1d");
        TABLE_SOURCE_METRIKA_VISIT_PRIVATE_LOG_ROOT     = NJupiter::JoinYtPath(sourcePrefix, "logs/visit-v2-private-log/1d");

        TABLE_SOURCE_USER_SESSIONS_DAILY_ROOT                   = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/search/daily");
        TABLE_SOURCE_USER_SESSIONS_INCOMPLETE_DAILY_ROOT        = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/search/incomplete/daily");
        TABLE_SOURCE_USER_SESSIONS_BS_CHEVENT_LOG_DAILY_ROOT    = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/bs_chevent_log/daily");
        TABLE_SOURCE_USER_SESSIONS_DIRECT_URLS_DAILY_ROOT       = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/direct_urls/daily");
        TABLE_SOURCE_USER_SESSIONS_SPYLOG_DAILY_ROOT            = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/spy_log_v2/daily");
        TABLE_SOURCE_USER_SESSIONS_SG_DAILY_ROOT                = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/similargroup/daily");
        TABLE_SOURCE_USER_SESSIONS_WATCHLOG_DAILY_ROOT          = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/watch_log_tskv/daily");

        TABLE_SOURCE_USER_SESSIONS_FAST_ROOT                    = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/search/fast");
        //TABLE_SOURCE_USER_SESSIONS_BS_CHEVENT_LOG_FAST_ROOT     = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/bs_chevent_log/fast");
        //TABLE_SOURCE_USER_SESSIONS_DIRECT_URLS_FAST_ROOT        = NJupiter::JoinYtPath(sourcePrefix, "user_sessions/pub/direct_urls/fast");

        TABLE_PARSED_USER_SESSIONS_ROOT                 = NJupiter::JoinYtPath(destinationPrefix, "searchqueries", "user_sessions");
        TABLE_PARSED_USER_SESSIONS_ROBOTS_METRIKA_ROOT  = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_ROOT, "robots", "metrika");
        TABLE_PARSED_USER_SESSIONS_DAILY_ROOT           = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_ROOT, "daily");
        TABLE_PARSED_USER_SESSIONS_FAST_ROOT            = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_ROOT, "fast");
        TABLE_PARSED_USER_SESSIONS_PRSLOG_DAILY_ROOT    = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_ROOT, "prslog", "daily");
        TABLE_PARSED_USER_SESSIONS_STATS_ROOT           = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_ROOT, "statistics");
        TABLE_PARSED_USER_SESSIONS_STATS_DAILY_ROOT     = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_STATS_ROOT, "daily");
        TABLE_PARSED_USER_SESSIONS_STATS_FAST_ROOT      = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_STATS_ROOT, "fast");

        TABLE_PARSED_USER_SESSIONS_REF_ROOT             = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_ROOT, "reference");
        TABLE_PARSED_USER_SESSIONS_REF_METRIKA_ROOT     = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_REF_ROOT, "metrika");
        TABLE_PARSED_USER_SESSIONS_REF_STATS            = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_REF_ROOT, "statistics");

        TABLE_PARSED_USER_SESSIONS_HOST2VEC_ROOT                = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_ROOT, "host2vec");
        TABLE_PARSED_USER_SESSIONS_HOST2VEC_SERP_DAILY_ROOT     = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_HOST2VEC_ROOT, "search", "daily");
        TABLE_PARSED_USER_SESSIONS_HOST2VEC_SPYLOG_DAILY_ROOT   = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_HOST2VEC_ROOT, "spylog", "daily");
        TABLE_PARSED_USER_SESSIONS_HOST2VEC_SG_DAILY_ROOT       = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_HOST2VEC_ROOT, "similargroup", "daily");
        TABLE_PARSED_USER_SESSIONS_HOST2VEC_WATCHLOG_DAILY_ROOT = NJupiter::JoinYtPath(TABLE_PARSED_USER_SESSIONS_HOST2VEC_ROOT, "watchlog", "daily");

        TABLE_CONVERTED_QUERIES_V4_ROOT                 = NJupiter::JoinYtPath(destinationPrefix, "searchqueries", "converted_v4");

        TABLE_SOURCE_USER_SESSIONS_EVENT_MONEY_DAILY_ROOT       = "statbox/cube/daily/product_money/v1";
    }

public:
    TString MR_SERVER_HOST_USER_SESSIONS;

    TString TABLE_SOURCE_FRAUD_UID_TYPES_ROOT;

    TString TABLE_SOURCE_METRIKA_HIT_LOG_ROOT;
    TString TABLE_SOURCE_METRIKA_HIT_PRIVATE_LOG_ROOT;
    TString TABLE_SOURCE_METRIKA_VISIT_LOG_ROOT;
    TString TABLE_SOURCE_METRIKA_VISIT_PRIVATE_LOG_ROOT;

    TString TABLE_SOURCE_USER_SESSIONS_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_INCOMPLETE_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_BS_CHEVENT_LOG_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_DIRECT_URLS_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_SPYLOG_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_SG_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_WATCHLOG_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_FAST_ROOT;
    //TString TABLE_SOURCE_USER_SESSIONS_BS_CHEVENT_LOG_FAST_ROOT;
    //TString TABLE_SOURCE_USER_SESSIONS_DIRECT_URLS_FAST_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_DAILY_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_FAST_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_PRSLOG_DAILY_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_ROBOTS_METRIKA_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_STATS_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_STATS_DAILY_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_STATS_FAST_ROOT;

    TString TABLE_PARSED_USER_SESSIONS_REF_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_REF_METRIKA_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_REF_STATS;

    
    TString TABLE_PARSED_USER_SESSIONS_HOST2VEC_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_HOST2VEC_SERP_DAILY_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_HOST2VEC_SPYLOG_DAILY_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_HOST2VEC_SG_DAILY_ROOT;    
    TString TABLE_PARSED_USER_SESSIONS_HOST2VEC_WATCHLOG_DAILY_ROOT;

    TString TABLE_CONVERTED_QUERIES_V4_ROOT;

    TString TABLE_SOURCE_USER_SESSIONS_EVENT_MONEY_DAILY_ROOT;
};

} //namespace NWebmaster
