#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/searchqueries-mr/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TAttrName {
    static constexpr char const UploadTime[]    = "upload_time";
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MR_SERVER_HOST_MAIN                             = TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER;

        TABLE_EXPORT_ROOT                               = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;

        TABLE_SOURCE_QUERIES_CONVERTED_PREFIX           = TCommonYTConfigSQ::CInstance().TABLE_CONVERTED_QUERIES_V4_ROOT;

        TABLE_AUTOCAMPAIGN_SOURCE_DOMAINS               = "//home/yabs/autocampaign/DomainsStats";
        TABLE_AUTOCAMPAIGN_EXPORT_GROUPS                = "//home/webmaster/prod/export/direct/groups";
        TABLE_AUTOCAMPAIGN_ROOT                         = "//tmp/webmaster/prod/export/autocampaign";
        TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES            = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "extracted_queries");
        TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES_FILTER     = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "extracted_queries_filter");
        TABLE_AUTOCAMPAIGN_ENRICHED_QUERIES             = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "enriched_queries");
        TABLE_AUTOCAMPAIGN_IDS_QUERIES                  = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "ids_queries");
        TABLE_AUTOCAMPAIGN_IDS_URLS                     = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "ids_urls");
        TABLE_AUTOCAMPAIGN_INTM_RAW_GROUPS              = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "intermediate/raw_groups");
        TABLE_AUTOCAMPAIGN_INTM_ENRICHED_GROUPS         = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "intermediate/enriched_groups");
        TABLE_AUTOCAMPAIGN_ENRICHED_GROUPS              = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "enriched_groups");
        TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC              = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "host2vec");
        TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_GROUPS       = TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC + ".g";
        TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOST_GROUPS  = TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC + ".hg";
        TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOSTS        = TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC + ".h";

    }

public:
    const float OPERATION_WEIGHT = 1.0f;

    TString MR_SERVER_HOST_MAIN;
    TString MR_SERVER_HOST_CATALOGIA;

    TString TABLE_EXPORT_ROOT;

    TString TABLE_SOURCE_QUERIES_CONVERTED_PREFIX;

    TString TABLE_AUTOCAMPAIGN_ROOT;
    TString TABLE_AUTOCAMPAIGN_EXPORT_GROUPS;
    TString TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES;
    TString TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES_FILTER;
    TString TABLE_AUTOCAMPAIGN_ENRICHED_QUERIES;
    TString TABLE_AUTOCAMPAIGN_IDS_QUERIES;
    TString TABLE_AUTOCAMPAIGN_IDS_URLS;
    TString TABLE_AUTOCAMPAIGN_INTM_RAW_GROUPS;
    TString TABLE_AUTOCAMPAIGN_INTM_ENRICHED_GROUPS;
    TString TABLE_AUTOCAMPAIGN_ENRICHED_GROUPS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_GROUPS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOST_GROUPS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOSTS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_DOMAINS;};

} //namespace NWebmaster
