#include <library/cpp/getopt/modchooser.h>

#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>

#include "config.h"

namespace NWebmaster {

void LogInfo(const TString &msg) {
    LOG_INFO("%s", msg.data());
}

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    using namespace NWebmaster;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TModChooser modChooser;
    //modChooser.AddMode("ClustersExtract", TaskWMClustersExtract, "WMClusters extract task");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());

    TCustomYTEnvironment::Instance().Init(envRoot);

    TLogger::Instance();
    NYTUtils::DisableLogger();

    return modChooser.Run(modeArgs);
}
