#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/processors/user_sessions/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TAttrName {
    static constexpr char const UploadTime[]    = "upload_time";
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MR_SERVER_HOST_MAIN                         = TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER;
        MR_SERVER_HOST_CATALOGIA                    = "hahn.yt.yandex.net";
        MR_SERVER_HOST_XMLSEARCH                    = "hahn.yt.yandex.net";

        TABLE_EXPORT_ROOT                           = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;

        TABLE_SOURCE_CATALOGIA_DOMAINS              = "//home/bannerland/data/dse/preparing/dyn-perf-domains";
        TABLE_SOURCE_QUERIES_CONVERTED_PREFIX       = TCommonYTConfigSQ::CInstance().TABLE_CONVERTED_QUERIES_V4_ROOT;

        TABLE_CATALOGIA_ROOT                        = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "catalogia");
        TABLE_CATALOGIA_SOURCE_ROOT                 = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "source");
        TABLE_CATALOGIA_SOURCE_CONTENT              = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "content");
        TABLE_CATALOGIA_SOURCE_MIRRORS              = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "mirrors");
        TABLE_CATALOGIA_SOURCE_HOSTS_FLT            = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "hosts-flt");
        TABLE_CATALOGIA_SOURCE_MIRRORS_FLT          = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "mirrors-flt");
        TABLE_CATALOGIA_SOURCE_QUERIES              = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "queries");
        TABLE_CATALOGIA_SOURCE_QUERIES_V2_ROOT      = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "queries-v2");
        TABLE_CATALOGIA_SOURCE_QUERIES_V2_PRS_ROOT  = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "queries-v2-prs");
        TABLE_CATALOGIA_SOURCE_ROBOTS               = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "robots");
        TABLE_CATALOGIA_SOURCE_ROBOTS_FLT           = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "robots-flt");
        TABLE_CATALOGIA_SOURCE_WM_CLUSTERS_ROOT     = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "wm_clusters");
        TABLE_CATALOGIA_SOURCE_XML_RAW_ROOT         = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "xmlsearch", "raw");
        TABLE_CATALOGIA_SOURCE_XML_PARSED_ROOT      = NYTUtils::JoinPath(TABLE_CATALOGIA_SOURCE_ROOT, "xmlsearch", "parsed");
        TABLE_CATALOGIA_EXPORT_LINKS_INT            = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "links");
        TABLE_CATALOGIA_EXPORT_LINKS_STAT           = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "links.stat");
        TABLE_CATALOGIA_EXPORT_QUERIES              = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "queries");
        TABLE_CATALOGIA_EXPORT_QUERIES_V2           = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "queries-v2");
        TABLE_CATALOGIA_EXPORT_QUERIES_V2_PRS       = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "queries-v2-prs");
        TABLE_CATALOGIA_EXPORT_WM_CLUSTERS          = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "wm_clusters");
        TABLE_CATALOGIA_EXPORT_WM_CLUSTERS_STAT     = NYTUtils::JoinPath(TABLE_CATALOGIA_ROOT, "wm_clusters.stat");
    }

public:
    const float OPERATION_WEIGHT = 1.0f;

    TString MR_SERVER_HOST_MAIN;
    TString MR_SERVER_HOST_CATALOGIA;
    TString MR_SERVER_HOST_XMLSEARCH;

    TString TABLE_EXPORT_ROOT;

    TString TABLE_SOURCE_QUERIES_CONVERTED_PREFIX;
    TString TABLE_SOURCE_CATALOGIA_DOMAINS;

    TString TABLE_CATALOGIA_ROOT;

    TString TABLE_CATALOGIA_SOURCE_ROOT;
    TString TABLE_CATALOGIA_SOURCE_CONTENT;
    TString TABLE_CATALOGIA_SOURCE_MIRRORS;
    TString TABLE_CATALOGIA_SOURCE_MIRRORS_FLT;
    TString TABLE_CATALOGIA_SOURCE_QUERIES;
    TString TABLE_CATALOGIA_SOURCE_QUERIES_V2_ROOT;
    TString TABLE_CATALOGIA_SOURCE_QUERIES_V2_PRS_ROOT;
    TString TABLE_CATALOGIA_SOURCE_ROBOTS;
    TString TABLE_CATALOGIA_SOURCE_ROBOTS_FLT;
    TString TABLE_CATALOGIA_SOURCE_HOSTS_FLT;
    TString TABLE_CATALOGIA_SOURCE_WM_CLUSTERS_ROOT;
    TString TABLE_CATALOGIA_SOURCE_HITS_DAILY;
    TString TABLE_CATALOGIA_SOURCE_HITS_MONTHLY;
    TString TABLE_CATALOGIA_SOURCE_XML_RAW_ROOT;
    TString TABLE_CATALOGIA_SOURCE_XML_PARSED_ROOT;

    TString TABLE_CATALOGIA_EXPORT_ROOT;
    TString TABLE_CATALOGIA_EXPORT_LINKS_INT;
    TString TABLE_CATALOGIA_EXPORT_LINKS_STAT;
    TString TABLE_CATALOGIA_EXPORT_QUERIES;
    TString TABLE_CATALOGIA_EXPORT_QUERIES_V2;
    TString TABLE_CATALOGIA_EXPORT_QUERIES_V2_PRS;
    TString TABLE_CATALOGIA_EXPORT_WM_CLUSTERS;
    TString TABLE_CATALOGIA_EXPORT_WM_CLUSTERS_STAT;

    const size_t TABLE_CATALOGIA_WM_CLUSTERS_DAYS = 18;
    const size_t INPUT_DAYS = 183;
};

} //namespace NWebmaster
