#include <library/cpp/getopt/modchooser.h>

#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>

#include "config.h"
#include "task_hosts.h"
#include "task_links.h"
#include "task_mirrors.h"
#include "task_robots.h"
#include "task_wm_clusters.h"
#include "task_user_sessions.h"
#include "task_user_sessions_v2.h"
#include "task_xmlsearch.h"

namespace NWebmaster {

void LogInfo(const TString &msg) {
    LOG_INFO("%s", msg.data());
}

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    using namespace NWebmaster;
    using namespace NWebmaster::NCatalogia;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TModChooser modChooser;
    modChooser.AddMode("ClustersExtract", TaskWMClustersExtract, "WMClusters extract task");
    modChooser.AddMode("ClustersGroup", TaskWMClustersGroup, "WMClusters group task");
    modChooser.AddMode("ClustersGenerateBase", TaskWMClustersGenerateBase, "WMClusters base generate task");
    modChooser.AddMode("ClustersGenerateShard", TaskWMClustersGenerateShard, "WMClusters shard generate task");
    modChooser.AddMode("ClustersContentShard", TaskWMClustersContentToQueriesShard, "WMClusters shard content task");
    modChooser.AddMode("ClustersContentMerge", TaskWMClustersContentToQueriesMerge, "WMClusters merge content task");
    modChooser.AddMode("Hosts", TaskHostsFilter, "Hosts filter task");
    modChooser.AddMode("InternalLinks", TaskInternalLinks, "InternalLinks task");
    modChooser.AddMode("Mirrors", TaskMirrors, "Mirrors task");
    modChooser.AddMode("Robots", TaskRobots, "Robots task");
    modChooser.AddMode("UserSessions", TaskUserSessions, "UserSessions task");
    modChooser.AddMode("UserSessionsV2", TaskUserSessionsV2, "UserSessions v2 task");
    modChooser.AddMode("UserSessionsV2Prs", TaskUserSessionsV2Prs, "UserSessions v2 PRS task");
    modChooser.AddMode("XMLLogsParse", TaskXMLSearch, "Parse raw XML logs");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());

    TCustomYTEnvironment::Instance().Init(envRoot);

    TLogger::Instance();
    NYTUtils::DisableLogger();

    return modChooser.Run(modeArgs);
}
