#include <util/datetime/cputimer.h>
#include <util/draft/datetime.h>
#include <util/generic/deque.h>
#include <util/generic/hash_set.h>
#include <util/generic/size_literals.h>
#include <util/generic/vector.h>

#include <library/cpp/containers/comptrie/comptrie.h>
#include <library/cpp/containers/comptrie/prefix_iterator.h>
#include <library/cpp/string_utils/url/url.h>

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/protos/yamr.pb.h>

#include <robot/jupiter/protos/export.pb.h>
#include <robot/jupiter/protos/external/host_mirror.pb.h>
#include <robot/library/yt/static/command.h>
#include <robot/library/yt/static/tags.h>

#include <wmconsole/version3/library/jupiter/jupiter.h>
#include <wmconsole/version3/processors/user_sessions/exports/catalogia/protos/catalogia.pb.h>
#include <wmconsole/version3/processors/user_sessions/library/utils.h>
#include <wmconsole/version3/processors/user_sessions/protos/user_sessions.pb.h>
#include <wmconsole/version3/protos/queries2.pb.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/owners.h>
#include <wmconsole/version3/wmcutil/url.h>
#include <wmconsole/version3/wmcutil/yt/triggers.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"

#include "task_hosts.h"

namespace NWebmaster {
namespace NCatalogia {

using namespace NJupiter;

//ReduceBy Host
struct TUserSessionsHostsReducer : public NYT::IReducer<NYT::TTableReader<NUserSessions::NProto::TStatistics>, NYT::TTableWriter<NProto::TCatalogiaHost>> {
    void Do(TReader *input, TWriter *output) override {
        NProto::TCatalogiaHost dstMsg;
        dstMsg.SetHost(input->GetRow().GetHost());
        output->AddRow(dstMsg);
    }
};

REGISTER_REDUCER(TUserSessionsHostsReducer)

int TaskHostsFilter(int, const char **) {
    const auto &cfg = TConfig::CInstance();

    NYT::IClientPtr clientMain = NYT::CreateClient(cfg.MR_SERVER_HOST_MAIN);

    TDeque<NYTUtils::TTableInfo> tables;
    NYTUtils::GetTableList(clientMain, TCommonYTConfigSQ::CInstance().TABLE_PARSED_USER_SESSIONS_STATS_DAILY_ROOT, tables);
    std::sort(tables.rbegin(), tables.rend(), NYTUtils::TTableInfo::TNameLess());
    if (tables.size() < cfg.INPUT_DAYS) {
        ythrow yexception() << "user_sessions, host-filter, there is no enought tables";
    }
    tables.resize(cfg.INPUT_DAYS);

    Cout << tables.begin()->Name << Endl;
    TYtSourceTrigger hostsTrigger(clientMain, cfg.TABLE_CATALOGIA_SOURCE_HOSTS_FLT);
    if (!hostsTrigger.NeedUpdate(tables.begin()->Name)) {
        LOG_INFO("user_sessions, host-filter is already updated");
    }

    NYTUtils::CreatePath(clientMain, cfg.TABLE_CATALOGIA_SOURCE_ROOT);
    NYT::ITransactionPtr tx = clientMain->StartTransaction();

    TDeque<TTable<NUserSessions::NProto::TStatistics>> inputTables;
    for (auto &table : tables) {
        TTable<NUserSessions::NProto::TStatistics> inputTable(tx, table.Name);
        inputTables.push_back(inputTable.SelectFields({"Host"}));
        LOG_INFO("user_sessions, host-filter, input %s", table.Name.c_str());
    }

    LOG_INFO("user_sessions, host-filter, output %s", cfg.TABLE_CATALOGIA_SOURCE_HOSTS_FLT.c_str());

    TCombineReduceCmd<TUserSessionsHostsReducer, TUserSessionsHostsReducer>(tx)
        .Inputs(inputTables)
        .Output(TTable<NProto::TCatalogiaHost>(tx, cfg.TABLE_CATALOGIA_SOURCE_HOSTS_FLT))
        .ReducerCpuLimit(0.1)
        .ReduceBy({"Host"})
        .Do()
    ;

    TSortCmd<NProto::TCatalogiaHost>(tx, TTable<NProto::TCatalogiaHost>(tx, cfg.TABLE_CATALOGIA_SOURCE_HOSTS_FLT))
        .By({"Host"})
        .Do()
    ;

    hostsTrigger.Update(tx, tables.begin()->Name);
    tx->Commit();

    return 0;
}

} //namespace NCatalogia
} //namespace NWebmaster
