#pragma once

#include "config.h"

namespace NWebmaster {
namespace NCatalogia {

struct TTablePathConfig {
    TTablePathConfig(const TString &tmpRoot, const TString &tableName)
        : TmpRoot(tmpRoot)
        , TableName(tableName)
    {
    }

    #define DEFINE_CONFIG_TMP(name, suffix)     TString name(const TString &tableName = "") const { return NYTUtils::JoinPath(TmpRoot, tableName.empty() ? TableName : tableName, suffix); }
    DEFINE_CONFIG_TMP(URLCLUSTER_OWNERS_INFO, "owners-info")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_EXTRACTED, "extracted")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FILTERED_BY_OWNERS, "filtered-by-owners")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_INFO, "queries-info")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_OWNERS_FILTER, "owners-filter")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_QRU, "unique-qru")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_OQR, "unique-oqr-new")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_OUR, "unique-our-new")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FOREIGN, "foreign-queries-3")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FOREIGN_COUNTER, "foreign-queries-counter")
    DEFINE_CONFIG_TMP(URLCLUSTER_URLS_FOREIGN, "foreign-urls")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_INFO_QRU, "queries-info-qru")
    DEFINE_CONFIG_TMP(URLCLUSTER_URLS_INFO, "urls-info")
    #undef DEFINE_CONFIG_TMP

    TString GetTmpRoot() const {
        return NYTUtils::JoinPath(TmpRoot, TableName);
    }

public:
    TString TmpRoot;
    TString TableName;
};

inline TTablePathConfig GetPathConfig(const TString &tableName = "wm_clusters") {
    return TTablePathConfig(
        TConfig::CInstance().TABLE_CATALOGIA_SOURCE_WM_CLUSTERS_ROOT,
        tableName
    );
}

inline bool IsPornoQuery(int upperPornoUpperPl) {
    return upperPornoUpperPl == 100;
}

int TaskWMClustersExtract(int, const char **);
int TaskWMClustersGroup(int, const char **);
int TaskWMClustersGenerateBase(int, const char **);
int TaskWMClustersGenerateShard(int, const char **);
int TaskWMClustersContentToQueriesShard(int, const char **);
int TaskWMClustersContentToQueriesMerge(int, const char **);

} //namespace NCatalogia
} //namespace NWebmaster
