#include <util/stream/file.h>
#include <util/string/subst.h>

#include "batch_matcher.h"

namespace NWebmaster {

Pire::Scanner TScanner::Compile(const char* pattern) { // https://wiki.yandex-team.ru/users/dprokoptsev/pire/doc
    std::vector<wchar32> ucs4;

    Pire::Encodings::Utf8().FromLocal(pattern, pattern + strlen(pattern), std::back_inserter(ucs4));
    return Pire::Lexer(ucs4.begin(), ucs4.end())
        .AddFeature(Pire::Features::AndNotSupport())
        .SetEncoding(Pire::Encodings::Utf8())
        .Parse()
        .Surround() //      PCRE_ANCHORED
        .Compile<Pire::Scanner>();
}

TScanner::TScanner(const TDeque<TString> &filters) {
    TDeque<TString>::const_iterator it = filters.begin();

    if (!filters.empty()) {
        Scanner = Compile(filters.front().data());
        ++it; //skip first element;
    }

    for (; it != filters.end(); ++it) {
        Scanner = Pire::Scanner::Glue(Scanner, Compile(it->data()));
    }
}

} //namespace NWebmaster
