#include "common_parser_opts.h"

#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/library/env/yt.h>

namespace NWebmaster {

    TCommonParserOptsParser& TCommonParserOptsParser::AddEnvRoot() {
        Params.AddOptional("env-root", "YT path prefix part", "<yt-path>", "prod", &Options.EnvRoot);
        return *this;
    }

    TCommonParserOptsParser& TCommonParserOptsParser::AddLogPath() {
        Params.AddOptional("log-path", "FS path for logs", "<fs-path>", &Options.LogPath);
        return *this;
    }

    TCommonParserOptsParser& TCommonParserOptsParser::AddYtProxy() {
        Params.AddOptional("yt-proxy", "YT cluster", "<server-name>", &Options.YtProxy);
        return *this;
    }

    TCommonParserOptsParser& TCommonParserOptsParser::AddYtPrefix() {
        Params.AddOptional("yt-prefix", "YT path prefix", "<yt-path>", &Options.YtPrefix);
        return *this;
    }

    TCommonParserOptsParser& TCommonParserOptsParser::AddEnableStderrLog() {
        Params.AddOptionalFlag("enable-stderr-log", "Allow to write log messages to stderr", &Options.EnableStderrLog);
        return *this;
    }


    TCommonParserOpts ParseCommonOptions(int argc, const char** argv) {
        NJupiter::TCmdParams params;

        TCommonParserOpts commonParserOpts;
        TCommonParserOptsParser(params, commonParserOpts)
            .AddEnvRoot()
            .AddLogPath();

        params.Parse(argc, argv);

        return commonParserOpts;
    }

    void InitCommonSingletones(const TCommonParserOpts& commonParserOpts, bool enableStderrLog) {
        TArgs::Instance().LogPath = commonParserOpts.LogPath;
        TCustomYTEnvironment::Instance().Init(commonParserOpts.EnvRoot);
        TLogger::Instance();
        if (!enableStderrLog) {
            NYTUtils::DisableLogger();
        }
    }
}
