#pragma once

#include <robot/jupiter/library/opt/common/params.h>

namespace NWebmaster {

    struct TCommonParserOpts {
        TString EnvRoot;
        TString LogPath;
        TString YtProxy;
        TString YtPrefix;
        bool EnableStderrLog;
    };

    class TCommonParserOptsParser {
    private:
        NJupiter::TCmdParams& Params;
        TCommonParserOpts& Options;

    public:
        TCommonParserOptsParser(NJupiter::TCmdParams& params, TCommonParserOpts& options)
            : Params(params)
            , Options(options)
        {
        }

        TCommonParserOptsParser& AddEnvRoot();
        TCommonParserOptsParser& AddLogPath();
        TCommonParserOptsParser& AddYtProxy();
        TCommonParserOptsParser& AddYtPrefix();
        TCommonParserOptsParser& AddEnableStderrLog();
    };

    TCommonParserOpts ParseCommonOptions(int argc, const char** argv);

    void InitCommonSingletones(const TCommonParserOpts& commonParserOpts, bool enableStderrLog = false);

}
