#pragma once

#include <util/generic/map.h>
#include <util/generic/singleton.h>
#include <library/cpp/deprecated/atomic/atomic.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/monitor_client.h>

namespace NWebmaster {

void MonitorPushHistory(const TString &monitorSuffix, const TMap<time_t, TMap<TString, double>> &history, const TString &prefix);

void MonitorPushLabel(const TString &suffix, const TString &label, const TString &service, double value);
void MonitorPushQualityLabel(const TString &suffix, const TString &label, double value);
void MonitorPushCountersLabel(const TString &suffix, const TString &label, double value);

void UpdateHistoryMonitor(NYT::IClientBasePtr client, const TString &suffix, const TString &historyTable, const TString &prefix);

} //namespace NWebmaster
