#pragma once

#include <util/generic/hash_set.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/protos/queries2.pb.h>

namespace NWebmaster {

enum EDirectFilteredQueryFlag {
    DFQF_QUERY_RESIZED         = 0x01,
    DFQF_REMOVED_SYMBOLS       = 0x02,
    DFQF_REMOVED_LONG_WORDS    = 0x04,
};

struct TQueryDigest {
    TQueryDigest();

    void Reset();
    void Add(const proto::queries2::QueryMessage &msg);
    TString Signature() const;

public:
    size_t Shows;
    size_t Clicks;
    THashSet<int> Regions;
    ui64 QueriesHash;
};

struct TReduceSignHosts : public NYT::IReducer<NYT::TTableReader<NYT::TYaMRRow>, NYT::TTableWriter<NYT::TNode>> {
public:
    void Do(TReader *input, TWriter *output) override;
};

void CopyQueryMessagePart(const proto::queries2::QueryMessage &src, proto::queries2::QueryMessage &dst);
bool FilterAutoCampaignQuery(const TString &query, TString &filteredQuery, int &flags);
size_t SplitQueryMessageByPosition(const proto::queries2::QueryMessage &src, proto::queries2::QueryMessage &dst, ui32 position = 50);
void SplitQueryMessageByTime(const proto::queries2::QueryMessage &src, proto::queries2::QueryMessage &dst, int days = 7);
void SignQueryTable(NYT::IClientBasePtr client, const TString &input, const TString &output);

} //namespace NWebmaster
