#pragma once

namespace NWebmaster {
namespace NUserSessions {

enum ERequestSource {
    E_YANDEX_WEB_REQUEST,               //0
    E_YANDEX_WEBINSTANT_REQUEST,        //1
    E_YANDEX_SITESEARCH_WEB_REQUEST,    //2
    E_MOBILE_APP_YANDEX_WEB_REQUEST,    //3
    E_MOBILE_YANDEX_WEB_REQUEST,        //4
    E_TOUCH_YANDEX_WEB_REQUEST,         //5
    E_PAD_YANDEX_WEB_REQUEST,           //6

    E_DESKTOP_YANDEX_TURBO_REQUEST,     //7
    E_MOBILE_YANDEX_TURBO_REQUEST,      //8
    E_PAD_YANDEX_TURBO_REQUEST,         //9
    E_TOUCH_YANDEX_TURBO_REQUEST,       //10
    E_MOBILE_APP_YANDEX_TURBO_REQUEST,  //11
};

enum EResultSource {
    E_WEB_RESULT,                   //0
    E_WIZARD_RESULT,                //1
    E_BLENDER_WIZARD_RESULT,        //2
    E_MISC_RESULT,                  //3
    E_PRSLOG_WEB_RESULT,            //4
    E_PRSLOG_WEB_MISPELL_RESULT,    //5
    E_DIRECT_RESULT,                //6
};

enum ETableSource {
    E_CLEAN_SOURCE,          //0
    E_ROBOTS_SOURCE,         //1
    E_FRAUDS_SOURCE,         //2
    E_EVENT_MONEY_SOURCE,    //3
};

inline bool IsMobileRequestSource(ERequestSource source) {
    switch (source) {
    case E_MOBILE_APP_YANDEX_WEB_REQUEST:
    case E_MOBILE_YANDEX_WEB_REQUEST:
    case E_TOUCH_YANDEX_WEB_REQUEST:
    case E_PAD_YANDEX_WEB_REQUEST:
    case E_MOBILE_YANDEX_TURBO_REQUEST:
    case E_PAD_YANDEX_TURBO_REQUEST:
    case E_TOUCH_YANDEX_TURBO_REQUEST:
    case E_MOBILE_APP_YANDEX_TURBO_REQUEST:
        return true;
    default:
        return false;
    };
}

inline bool IsPadRequestSource(ERequestSource source) {
    switch (source) {
    case E_PAD_YANDEX_WEB_REQUEST:
    case E_PAD_YANDEX_TURBO_REQUEST:
        return true;
    default:
        return false;
    };
}

inline bool IsTurboRequestSource(ERequestSource source) {
    switch (source) {
    case E_DESKTOP_YANDEX_TURBO_REQUEST:
    case E_MOBILE_YANDEX_TURBO_REQUEST:
    case E_PAD_YANDEX_TURBO_REQUEST:
    case E_TOUCH_YANDEX_TURBO_REQUEST:
    case E_MOBILE_APP_YANDEX_TURBO_REQUEST:
        return true;
    default:
        return false;
    };
}

} //namespace NUserSessions
} //namespace NWebmaster
