#pragma once

#include <util/generic/string.h>
#include <util/string/cast.h>

#include <library/cpp/string_utils/url/url.h>

#include <wmconsole/version3/processors/user_sessions/protos/user_sessions.pb.h>

#include "types.h"

namespace NWebmaster {
namespace NUserSessions {

inline bool IsVisibleQueryInWebmaster(const NProto::TQuery &row, bool includeFraud = false) {
    if (!includeFraud) {
        //https://st.yandex-team.ru/AF-6495
        if (row.GetTimestamp() >= 1616533200 && row.GetUIDFraudRank() >= 971) {
            return false;
        }
    }

    if (row.HasIsMetrikaRobot()) {
        return false;
    }

    switch(row.GetRequestSource()) {
    case E_YANDEX_WEB_REQUEST:
    case E_YANDEX_WEBINSTANT_REQUEST:
    case E_YANDEX_SITESEARCH_WEB_REQUEST:
    case E_MOBILE_APP_YANDEX_WEB_REQUEST:
    case E_MOBILE_YANDEX_WEB_REQUEST:
    case E_TOUCH_YANDEX_WEB_REQUEST:
    case E_PAD_YANDEX_WEB_REQUEST:
        break;
    default:
        return false;
    }

    switch(row.GetResultSource()) {
    case E_WEB_RESULT:
    case E_BLENDER_WIZARD_RESULT:
        break;
    default:
        return false;
    }

    return true;
}

inline bool IsVisiblePrsLogQuery(const NProto::TQuery &row) {
    if (row.HasIsMetrikaRobot()) {
        return false;
    }

    switch(row.GetRequestSource()) {
    case E_YANDEX_WEB_REQUEST:
    case E_YANDEX_WEBINSTANT_REQUEST:
    case E_YANDEX_SITESEARCH_WEB_REQUEST:
    case E_MOBILE_APP_YANDEX_WEB_REQUEST:
    case E_MOBILE_YANDEX_WEB_REQUEST:
    case E_TOUCH_YANDEX_WEB_REQUEST:
    case E_PAD_YANDEX_WEB_REQUEST:
        break;
    default:
        return false;
    }

    switch(row.GetResultSource()) {
    case E_PRSLOG_WEB_RESULT:
    case E_PRSLOG_WEB_MISPELL_RESULT:
        break;
    default:
        return false;
    }

    return true;
}

inline bool GetUIDTimestamp(const TString &uid, ui32 &timestamp) {
    const ui32 LENGTH = 10;
    if (uid.size() < LENGTH) {
        return false;
    }

    try {
        timestamp = FromString<ui32>(TStringBuf(uid).Last(LENGTH));
        return timestamp > 1000000000;
    } catch (yexception &) {
        return false;
    }
}

inline bool SplitAndFixUrl(const TString &url, TString &host, TString &path) {
    const int MAX_PATH_LEN = 8192;

    SplitUrlToHostAndPath(url, host, path);
    if (host.empty()) {
        return false;
    }

    host.to_lower();
    if (host.find("://") == TString::npos) {
        host = "http://" + host;
    }

    if (path.empty()) {
        path = "/";
    }

    if (path.size() > MAX_PATH_LEN) {
        path.resize(MAX_PATH_LEN);
    }

    return true;
}

} //namespace NUserSessions
} //namespace NWebmaster
