#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/processors/user_sessions/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {
namespace NNiche {

struct TAttrName {
    static constexpr char const UploadTime[]            = "upload_time";
    static constexpr char const SrcModificationTime[]   = "source_modification_time";
    static constexpr char const LastMinedUserSession[] = "LAST_MINED_TABLES";
    static constexpr char const SourceWeekNumber[] = "SourceWeekNumber";

};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MR_SERVER_HOST                              = TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER;

        TABLE_EXPORT_ROOT                           = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;

        TABLE_SOURCE_GROUPS_SETTINGS                = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_USER_ROOT, "query_groups");
        TABLE_SOURCE_ADDED_RIVALS                   = "//home/webmaster/prod/export/iks_rival";
        //TABLE_SOURCE_ADDED_RIVALS                   = "//home/webmaster/users/iceflame/iks_rival";

        TABLE_SOURCE_H2V_SPYLOG                     = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "host2vec", "spylog-300");
        TABLE_SOURCE_H2V_SIMILARGROUP               = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "host2vec", "similargroup-300");

        TABLE_NICHE_ROOT                            = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "searchqueries", "niche");
        TABLE_NICHE_TMP_ROOT                        = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp");

        TABLE_NICHE_SOURCE_ADDED_RIVALS             = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "source", "rivals", "added-rivals");
        TABLE_NICHE_SOURCE_FAVORITE_QUERIES         = "//home/webmaster/prod/searchqueries/niche2/reports/queries/export_groups";
        TABLE_NICHE_SOURCE_H2V_SPYLOG               = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "source", "host2vec", "spylog-300");
        TABLE_NICHE_SOURCE_H2V_SIMILARGROUP         = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "source", "host2vec", "similargroup-300");
        TABLE_SOURCE_QUERIES_NICHE                  = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "source", "queries_niche");
        TABLE_SOURCE_LATEST_QUERIES_NICHE           = NYTUtils::JoinPath(TABLE_SOURCE_QUERIES_NICHE, "latest");
        TABLE_USER_SESSION_BASE_ROOT                = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "searchqueries", "user_sessions", "daily");
        TABLE_USER_SESSION_ROOT                     = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "searchqueries", "user_sessions", "daily_sampled");
        TABLE_SOURCE_WEBMASTER_HOSTS                = TCommonYTConfig::CInstance().TABLE_SOURCE_WEBMASTER_HOSTS;
        TABLE_SOURCE_WEBMASTER_NISHE_SETTINGS       = NYTUtils::JoinPath(TABLE_EXPORT_ROOT,"webmaster-nishe-settings");
        TABLE_TMP_RIVAL                             = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp","rival");
        TABLE_TMP_MINED_RIVAL_QUERIES               = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp","mined_rival_queries");
        TABLE_TMP_SELECTED_RIVAL                    = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp","selected_rival");
        TABLE_TMP_NICHE_STATIC_QUERY_STATISTICS     = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "static_query");
        TABLE_TMP_HOST_QUERY_DINAMIC_NICHE          = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "host_query_dinamic_niche");
        TABLE_TMP_HOST_QUERY                        = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "host_query");
        TABLE_TMP_HOST_QUERY_IMPORT                 = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "host_query_import");
        TABLE_TMP_USER_SESSION_QUERY_COUNT          = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "host_query_count");
        TABLE_TMP_CROSS_SESSION_QUERY_INFO          = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "host_query_cross_session");
        TABLE_TMP_RIVAL_QUERY_COUNT                 = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "rival_query_count");
        TABLE_TMP_POPULARITY                        = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "query_popularity");
        TABLE_TMP_REGION_DEV_POPULARITY             = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "region_dev_query_popularity");
        TABLE_TMP_QUERIES_RIVAL_REPORT              = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "rival_queries_report");
        TABLE_TMP_TOTAL_POPULARITY                  = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "total_popularity");
        TABLE_TMP_USER_SESSION_BY_QUERY             = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp", "user_session_by_query");
        TABLE_IMPORT_RIVAL                          = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "import", "rival");
        TABLE_IMPORT_RIVAL_QUERIES                  = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "import", "rival_queries");
        TABLE_IMPORT_QUERIES                        = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "import", "queries");
        TABLE_IMPORT_QUERIES_RIVAL_REPORT           = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "import", "rival_queries_report");
    }


public:
    static const TString LoadFirstUnprocessedUserSession(NYT::IClientBasePtr client, const TString& sourcePrefix, TString lastProcessed) {
        TDeque<NYTUtils::TTableInfo> sourceTables;
        TDeque<NYTUtils::TTableInfo> tables;
        NYTUtils::GetTableList(client, sourcePrefix, tables);
        std::sort(tables.begin(), tables.end(), NYTUtils::TTableInfo::TNameLess());
        for (auto table : tables) {
            if (NYTUtils::GetTableName(table.Name) > lastProcessed) {
                return table.Name;
            }
        }
        return "";
    }

    const float OPERATION_WEIGHT = 1.0f;

    TString MR_SERVER_HOST;

    TString TABLE_EXPORT_ROOT;
    TString TABLE_SOURCE_ADDED_RIVALS;
    TString TABLE_SOURCE_GROUPS_SETTINGS;
    TString TABLE_SOURCE_H2V_SPYLOG;
    TString TABLE_SOURCE_H2V_SIMILARGROUP;

    TString TABLE_NICHE_ROOT;
    TString TABLE_NICHE_TMP_ROOT;
    TString TABLE_NICHE_SOURCE_ADDED_RIVALS;
    TString TABLE_NICHE_SOURCE_FAVORITE_QUERIES;
    TString TABLE_NICHE_SOURCE_H2V_SPYLOG;
    TString TABLE_NICHE_SOURCE_H2V_SIMILARGROUP;
    TString TABLE_SOURCE_QUERIES_NICHE;
    TString TABLE_SOURCE_LATEST_QUERIES_NICHE;

    TString TABLE_USER_SESSION_BASE_ROOT;
    TString TABLE_USER_SESSION_ROOT;
    TString TABLE_SOURCE_WEBMASTER_HOSTS;
    TString TABLE_SOURCE_WEBMASTER_NISHE_SETTINGS;
    TString TABLE_TMP_MINED_RIVAL_QUERIES;
    TString TABLE_TMP_SELECTED_RIVAL;
    TString TABLE_TMP_HOST_QUERY_DINAMIC_NICHE;
    TString TABLE_TMP_HOST_QUERY;
    TString TABLE_TMP_HOST_QUERY_IMPORT;
    TString TABLE_TMP_NICHE_STATIC_QUERY_STATISTICS;
    TString TABLE_TMP_RIVAL;
    TString TABLE_TMP_USER_SESSION_QUERY_COUNT;
    TString TABLE_TMP_POPULARITY;
    TString TABLE_TMP_CROSS_SESSION_QUERY_INFO;
    TString TABLE_TMP_RIVAL_QUERY_COUNT;
    TString TABLE_TMP_QUERIES_RIVAL_REPORT;
    TString TABLE_TMP_REGION_DEV_POPULARITY;
    TString TABLE_TMP_TOTAL_POPULARITY;
    TString TABLE_TMP_USER_SESSION_BY_QUERY;

    TString TABLE_IMPORT_RIVAL;
    TString TABLE_IMPORT_QUERIES;
    TString TABLE_IMPORT_RIVAL_QUERIES;
    TString TABLE_IMPORT_QUERIES_RIVAL_REPORT;
};

} //namespace NNiche
} //namespace NWebmaster
