#include <library/cpp/getopt/modchooser.h>

#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>

#include <wmconsole/version3/processors/user_sessions/niche/conf/config.h>

#include "task_source_favorites.h"
#include "task_source_host2vec.h"
//#include "task_mine_rival_queries.h"
#include "task_source_rivals.h"
//#include "task_prepare_queries.h"
#include "task_prepare_queries.h"
#include "task_import_queries_and_rivals.h"

namespace NWebmaster {

void LogInfo(const TString &msg) {
    LOG_INFO("%s", msg.data());
}

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    using namespace NWebmaster;
    using namespace NWebmaster::NNiche;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TModChooser modChooser;
    modChooser.AddMode("SourceAddedRivals", TaskSourceAddedRivals, "Update added rivals source task");
    modChooser.AddMode("SourceFavorites", TaskSourceFavorites, "Update favorite queries source task");
    modChooser.AddMode("SourceHost2vec", TaskSourceHost2vec, "Update host2vec source task");
    //modChooser.AddMode("MineRivalQueries", TaskMineRivalQueries, "Mine queries through rival");
    modChooser.AddMode("PrepareQueryData",TaskPrepareQueries, "Prepare niche statistic for queries and hosts (v2)");
    modChooser.AddMode("ImportQueriesAndRivals", ImportQueriesAndRivals, "Prepare rival and queries for import in backend");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());

    TCustomYTEnvironment::Instance().Init(envRoot);

    TLogger::Instance();
    NYTUtils::DisableLogger();

    return modChooser.Run(modeArgs);
}
