#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/processors/user_sessions/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {
namespace NNiche2 {
enum ESegmentType {
    E_USER_SESSION_GOOD,
    E_USER_SESSION_BAD,
    E_PRS_LOGS,
    E_POTENCIAL,
    E_USER_SESSION,
    E_USERS_GROUP,
};

struct TAttrName {
    static constexpr char const SrcModificationTime[]   = "source_modification_time";
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        const auto &root = TCommonYTConfig::CInstance().TABLE_ROOT;

        MR_SERVER_HOST                              = TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER;
        MR_RADAR_HOST                               = TCommonYTConfig::CInstance().MR_SERVER_HOST_RADAR;

        TABLE_INIT_QUERIES_ROOT                     = NYTUtils::JoinPath(root, "searchqueries");
        TABLE_NICHE_ROOT                            = NYTUtils::JoinPath(TABLE_INIT_QUERIES_ROOT, "niche2");

        TABLE_PREPARED_QUERIES                      = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "daily");

        TABLE_USER_SESSIONS_DAILY                   = NYTUtils::JoinPath(TABLE_INIT_QUERIES_ROOT, "user_sessions/daily");
        TABLE_PRS_LOG_DAILY                         = NYTUtils::JoinPath(TABLE_INIT_QUERIES_ROOT, "user_sessions/prslog/daily");

        TABLE_RIVALS_ROOT                           = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "rivals");
        TABLE_CLUSTERS_ROOT                         = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "clusters");
        TABLE_REPORTS_ROOT                          = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "reports");
        TABLE_QUERIES_TMP                           = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "tmp");
        TABLE_RADAR_CLUSTERS_SOURCE                 = "//home/radar_top_sites/production/export/domain_markup";

        TABLE_INTERMEDIATE_TABLE                    = NYTUtils::JoinPath(TABLE_QUERIES_TMP, "intermediate");
        TABLE_FIRST_REPORT_ROOT                     = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "queries");
        TABLE_RIVALS_VISIBILITY_REPORT_ROOT         = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "visibility_report");
        TABLE_GROUPS                                = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "groups");

        DSSM_MODEL                                  = NYTUtils::JoinPath(TABLE_CLUSTERS_ROOT, "l3_model.dssm");

        TABLE_SEARCHSHARE_QUERY_TO_CLUSTER          = NYTUtils::JoinPath(TABLE_CLUSTERS_ROOT, "searchshare_query_to_cluster");
        TABLE_SEARCHSHARE_QUERY_TO_CLUSTER_HASHED   = NYTUtils::JoinPath(TABLE_CLUSTERS_ROOT, "searchshare_query_to_cluster_hashed");
        TABLE_SEARCHSHARE_QUERY_TO_CLUSTER_SAMPLED  = NYTUtils::JoinPath(TABLE_CLUSTERS_ROOT, "searchshare_query_to_cluster_hashed_sampled");
        TABLE_QUERY_TO_UID                          = NYTUtils::JoinPath(TABLE_QUERIES_TMP, "query_to_uid");
        TABLE_DOMAIN_TO_QUERY                       = NYTUtils::JoinPath(TABLE_QUERIES_TMP, "domain_to_query");
        TABLE_SEARCHSHARE_CLUSTERS                  = NYTUtils::JoinPath(TABLE_CLUSTERS_ROOT, "searchshare_clusters");
        TABLE_SEARCHSHARE_CLUSTERS_INFO             = NYTUtils::JoinPath(TABLE_CLUSTERS_ROOT, "searchshare_clusters_names");
        TABLE_SEARCHSHARE_CLUSTERS_FULL_INFO        = NYTUtils::JoinPath(TABLE_CLUSTERS_ROOT, "searchshare_clusters_calculated");
        TABLE_NICHE_CALCULATED                      = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "new_markets");

        TABLE_IKS_RIVAL                             = NYTUtils::JoinPath(root, "export", "iks_rival");
        TABLE_SPYLOG_SESSIONS                       = NYTUtils::JoinPath(root, "searchqueries", "niche", "source", "host2vec", "spylog-sessions");
        TABLE_SIMILARGROUP_SESSIONS                 = NYTUtils::JoinPath(root, "searchqueries", "niche", "source", "host2vec", "similargroup-sessions");

        TABLE_RIVALS                                = NYTUtils::JoinPath(TABLE_RIVALS_ROOT, "rivals");
        TABLE_WEBMASTER_HOSTS                       = NYTUtils::JoinPath(root, "export", "webmaster-hosts");

        TABLE_QUERY_HASHES                          = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "query_hash");
        TABLE_HOST_HASHES                           = NYTUtils::JoinPath(TABLE_NICHE_ROOT, "host_hash");
    }

public:
    const float OPERATION_WEIGHT = 1.0f;
    static constexpr const char *GEOBASE_FILE_LITE = "geodata4-tree+ling.bin";

    TString MR_SERVER_HOST;
    TString MR_RADAR_HOST;

    TString TABLE_INIT_QUERIES_ROOT;
    TString TABLE_NICHE_ROOT;
    TString TABLE_INTERMEDIATE_TABLE;
    TString TABLE_QUERY_HASHES;
    TString TABLE_HOST_HASHES;
    TString TABLE_RADAR_CLUSTERS_SOURCE;

    TString TABLE_RIVALS_ROOT;
    TString TABLE_CLUSTERS_ROOT;
    TString TABLE_QUERIES_TMP;

    TString TABLE_PREPARED_QUERIES;

    TString TABLE_USER_SESSIONS_DAILY;
    TString TABLE_PRS_LOG_DAILY;

    TString DSSM_MODEL;

    TString TABLE_SEARCHSHARE_CLUSTERS;
    TString TABLE_SEARCHSHARE_CLUSTERS_INFO;
    TString TABLE_SEARCHSHARE_CLUSTERS_FULL_INFO;

    // TString TABLE_SPIKES_QUERY_TO_CLUSTER;
    // TString TABLE_SPIKES_QUERY_TO_CLUSTER_HASHED;
    TString TABLE_SEARCHSHARE_QUERY_TO_CLUSTER;
    TString TABLE_SEARCHSHARE_QUERY_TO_CLUSTER_HASHED;
    TString TABLE_SEARCHSHARE_QUERY_TO_CLUSTER_SAMPLED;
    TString TABLE_QUERY_TO_UID;
    TString TABLE_DOMAIN_TO_QUERY;
    TString TABLE_NICHE_CALCULATED;
    TString TABLE_WEBMASTER_HOSTS;


    TString TABLE_IKS_RIVAL;
    TString TABLE_SPYLOG_SESSIONS;
    TString TABLE_SIMILARGROUP_SESSIONS;
    TString TABLE_RIVALS;

    TString TABLE_REPORTS_ROOT;
    TString TABLE_FIRST_REPORT_ROOT;
    TString TABLE_RIVALS_VISIBILITY_REPORT_ROOT;
    TString TABLE_GROUPS;
};

} //namespace NNiche2
} //namespace NWebmaster
