#include <library/cpp/getopt/modchooser.h>

#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>

#include <wmconsole/version3/processors/user_sessions/niche/conf/config.h>

#include "task_prepare_queries.h"
#include "task_prepare_rivals.h"
#include "task_apply_hash_to_clusters.h"
#include "task_get_cluster_names.h"

#include "task_prepare_report.h"

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    using namespace NWebmaster;
    using namespace NWebmaster::NNiche2;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TModChooser modChooser;
    modChooser.AddMode("PrepareQueries", TaskPrepareQueries, "Prepare queries (user sessions and prs) task");
    modChooser.AddMode("PrepareRivals", TaskPrepareRivals, "Prepare rivals task");
    modChooser.AddMode("ApplyHashQueriesInClusters", TaskApplyHashToClusterTables, "Apply hash to queries in cluster tables");
    modChooser.AddMode("GetClusterNames", TaskGetClusterNames, "Get cluster names and calculate centroids");

    modChooser.AddMode("PrepareReport", TaskPrepareReport, "Prepare first report");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());

    TCustomYTEnvironment::Instance().Init(envRoot);

    TLogger::Instance();
    NYTUtils::DisableLogger();

    return modChooser.Run(modeArgs);
}
