#pragma once

#include <time.h>

#include <wmconsole/version3/processors/user_sessions/conf/config.h>
#include <wmconsole/version3/processors/user_sessions/library/regions_limiter.h>
#include <wmconsole/version3/processors/user_sessions/library/source_tables.h>
#include <wmconsole/version3/processors/user_sessions/library/utils.h>
#include <wmconsole/version3/processors/user_sessions/protos/user_sessions.pb.h>
#include <wmconsole/version3/protos/queries2.pb.h>

namespace NWebmaster {
namespace NUserSessions {

template<class T>
struct TCounters {
    struct TCounter {
        void Add(const T &row) {
            Clicks += row.GetClicks();
            TurboClicks += row.GetTurboClicks();
            Shows += row.GetShows();
        }

    public:
        size_t Clicks = 0;
        size_t TurboClicks = 0;
        size_t Shows = 0;
    };

    using TResultSourceCounter  = THashMap<ui32, TCounter>;
    using TRequestSourceCounter = THashMap<ui32, TResultSourceCounter>;
    using TPositionCounter      = THashMap<ui32, TRequestSourceCounter>;
    using TRegionIdCounter      = THashMap<ui32, TPositionCounter>;
    using TIsPadCounter         = THashMap<bool, TRegionIdCounter>;
    using TIsMobileCounter      = THashMap<bool, TIsPadCounter>;

    void Add(const T &row) {
        Counters
            [row.GetIsMobile()]
            [row.GetIsPad()]
            [row.GetRegionId()]
            [row.GetPosition()]
            [row.GetRequestSource()]
            [row.GetResultSource()]
        .Add(row);
    }

    void Write(const TString &host, NYT::TTableWriter<NProto::TStatistics> *writer) const {
        NProto::TStatistics stats;
        stats.SetHost(host);

        for (const auto &isMobileObj : Counters) {
            const bool isMobile = isMobileObj.first;
            stats.SetIsMobile(isMobile);

            for (const auto &isPadObj : isMobileObj.second) {
                const bool isPad = isPadObj.first;
                stats.SetIsPad(isPad);

                for (const auto &regionObj : isPadObj.second) {
                    const ui32 regionId = regionObj.first;
                    stats.SetRegionId(regionId);

                    for (const auto &positionObj : regionObj.second) {
                        const ui32 position = positionObj.first;
                        stats.SetPosition(position);

                        for (const auto &requestSrcObj : positionObj.second) {
                            const ui32 requestSource = requestSrcObj.first;
                            stats.SetRequestSource(requestSource);

                            for (const auto &resultSrcObj : requestSrcObj.second) {
                                const ui32 resultSource = resultSrcObj.first;
                                const TCounter &counter = resultSrcObj.second;
                                stats.SetResultSource(resultSource);
                                stats.SetClicks(counter.Clicks);
                                stats.SetTurboClicks(counter.TurboClicks);
                                stats.SetShows(counter.Shows);
                                writer->AddRow(stats);
                            }
                        }
                    }
                }
            }
        }
    }

public:
    TIsMobileCounter Counters;
};

} //namespace NUserSessions
} //namespace NWebmaster
