#include <library/cpp/getopt/modchooser.h>

#include <wmconsole/version3/processors/user_sessions/library/common_parser_opts.h>
#include <wmconsole/version3/processors/user_sessions/conf/config.h>
#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "monitoring.h"
#include "push_stats.h"
#include "task_parse_daily.h"
#include "task_parse_fast.h"
#include "task_sync.h"
#include "table_config.h"

namespace NWebmaster {

void LogInfo(const TString &msg) {
    LOG_INFO("%s", msg.data());
}

int TaskMonitoring(int argc, const char **argv) {
    auto commonParserOpts = ParseCommonOptions(argc, argv);
    InitCommonSingletones(commonParserOpts);

    NMonitoring::UpdateMetrikaReference();
    return 0;
}

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    using namespace NWebmaster;
    using namespace NWebmaster::NUserSessions;

    TModChooser modChooser;
    modChooser.AddMode("ParseDaily", TaskParseDaily, "Parse daily user_sessions");
    modChooser.AddMode("ParseFast", TaskParseFast, "Parse fast user_sessions");
    modChooser.AddMode("PushStats", PushStats, "Push visit-v2-log vs sessions comparison stats to Solomon");
    modChooser.AddMode("Sync", TaskSync, "Sync parsed queries task");
    modChooser.AddMode("UpdateMonitoring", TaskMonitoring, "Update Metrika reference monitoring");

    return modChooser.Run(argc, argv);
}
