#pragma once

#include <quality/user_sessions/request_aggregate_lib/all.h>

#include <robot/library/yt/static/command.h>

#include "robots.h"
#include "table_config.h"

namespace NWebmaster {
namespace NUserSessions {

enum class EUserFraudType: int {
    Clean = 0,
    Robots = 1,
    Frauds = 2,
};

inline
int SetUserFraudTypeInMask(int baseMask, EUserFraudType fraudType) {
    return baseMask | (1 << static_cast<int>(fraudType));
}

inline
bool CheckUserFraudTypeInMask(int mask, EUserFraudType fraudType) {
    return (mask & (1 << static_cast<int>(fraudType))) != 0;
}

void ParseUserSessions(NYT::IClientBasePtr client, const TBlockStatInfo &bsi, const TTableConfig &ttcfg,
    const TMetrikaRobotHits &robotHits, int fraudTypeMask, bool force = true
);

} //namespace NUserSessions
} //namespace NWebmaster
