#include "robots.h"

namespace NWebmaster {
namespace NUserSessions {

using namespace NJupiter;

void TMetrikaRobotHits::LoadFromMetrikaCH(const TString &dateStr, TDeque<NProto::TMetrikaRobot> &robots) {
    for (unsigned int shard = 0; shard < METRIKA_SHARD_COUNT; shard++) {
        while (true) {
            try {
                LOG_INFO("user_session, robots, shard %u/%u", shard, METRIKA_SHARD_COUNT);
                LoadFromMetrikaCH(dateStr, robots, shard);
                break;
            } catch (yexception &e) {
                LOG_ERROR("user_sessions daily, unable to load robots from metrika %s: %s. Waiting 5 minutes", dateStr.c_str(), e.what());
                Sleep(TDuration::Minutes(5));
            }
        }
    }

    Sort(robots, [](const NProto::TMetrikaRobot &l, const NProto::TMetrikaRobot &r) {
        if (l.GetUserID() != r.GetUserID()) {
            return l.GetUserID() < r.GetUserID();
        } else if (l.GetUserIDType() != r.GetUserIDType()) {
            return l.GetUserIDType() < r.GetUserIDType();
        }
        return l.GetIsRobot() < r.GetIsRobot();
    });
}

void TMetrikaRobotHits::LoadFromMetrikaCH(const TString &dateStr, TDeque<NProto::TMetrikaRobot> &robots, unsigned int shard) {
    const TString PASSWORD = GetEnv("METRIKA_CH_PASSWORD");
    NClickHouse::TClientOptions opts;
    opts.SetHost("mtstat.yandex.ru");
    opts.SetUser("robot-webmaster");
    opts.SetPassword(PASSWORD);

    NProto::TMetrikaRobot row;
    NClickHouse::TClient client(opts);
    client.Select(Sprintf(
            "select UserID, UserIDType, IsRobot, cast(toUnixTimestamp(UTCEventTime) as UInt64) from hits_all "
            "where EventDate == toDate('%s') "
                "and SearchEngineID in (2, 13, 181) "
                "and UserID global in ("
                    "select distinct UserID from hits_all "
                    "where EventDate == toDate('%s') "
                        "and modulo(UserID, %u) == %u "
                        "and IsRobot != 0 "
                        "and SearchEngineID in (2, 13, 181) "
                        "and not (IsArtifical and not DontCountHits)"
                ") "
                "and not (IsArtifical and not DontCountHits)",
            dateStr.c_str(),
            dateStr.c_str(),
            METRIKA_SHARD_COUNT,
            shard
        ),
        [&](const NClickHouse::TBlock& block) {
            for (size_t i = 0; i < block.GetRowCount(); i++) {
                row.SetUserID(block[0]->As<NClickHouse::TColumnUInt64>()->At(i));
                row.SetUserIDType(block[1]->As<NClickHouse::TColumnUInt8>()->At(i));
                row.SetIsRobot(block[2]->As<NClickHouse::TColumnUInt8>()->At(i));
                row.SetTimestamp(block[3]->As<NClickHouse::TColumnUInt64>()->At(i));
                robots.push_back(row);
            }
        }
    );
}

void LoadMetrikaRobots(const TTableConfig &ttcfg, TMetrikaRobotHits &robotHits) {
    NYT::IClientBasePtr client = NYT::CreateClient(TConfig::CInstance().MR_SERVER_HOST_HITLOG);

    if (client->Exists(ttcfg.MetrikaRobotsTable)) {
        LOG_INFO("Loading Metrika robots from the table %s", ttcfg.MetrikaRobotsTable.data());
        robotHits.InitFromYT(client, ttcfg.MetrikaRobotsTable);
    } else {
        //TDeque<NProto::TMetrikaRobot> robots;
        //TMetrikaRobotHits::LoadFromMetrikaCH(ttcfg.TimestampStr, robots);
        //TMetrikaRobotHits::SaveToYT(client, robots, ttcfg.MetrikaRobotsTable);
        //robotHits.Init(robots);
        ythrow yexception() << "There is no robots table " << ttcfg.MetrikaRobotsTable;
    }
}

} //namespace NUserSessions
} //namespace NWebmaster
