use hahn;
--pragma yt.QueryCacheMode="disable";
--pragma yt.Pool="robot-webmaster";

$src_hit_log_root           = "//logs/hit-log/1d";
$src_hit_private_log_root   = "//logs/hit-private-log/1d";
$dst_root                   = "//home/webmaster/prod/searchqueries/user_sessions/robots/metrika";
$PERIOD = 14;

$src_days = (
    select aggregate_list(Period)
    from (
        select TableName(Path, "yt") as Period
        from folder($src_hit_log_root)
        where Type == "table"
        order by Period desc
        limit $PERIOD
    )
);

$dst_days = (
    select aggregate_list(Period)
    from (
        select TableName(Path, "yt") as Period
        from folder($dst_root)
        where Type == "table"
        order by Period desc
        limit $PERIOD
    )
);

define action $copy_logs($day) as 
    $src_path1 = $src_hit_log_root || "/" || $day;
    $src_path2 = $src_hit_private_log_root || "/" || $day;

    $dst_path = $dst_root || "/" || $day;

    $data = (
        select 
            UserID, 
            coalesce(UserIDType, 0) as UserIDType,
            UTCEventTime,
            coalesce(IsRobot, 0) as IsRobot,
            coalesce(SearchEngineID, 0) as SearchEngineID,
            coalesce(IsArtifical, False) as IsArtifical, 
            coalesce(DontCountHits, False) as DontCountHits
        from concat($src_path1, $src_path2)
        where 
            SearchEngineID IN (2, 13, 181)
            and (not (coalesce(IsArtifical, False) and (not coalesce(DontCountHits, False))))
            --and coalesce(IsRobot, 0) != 0
    );

    $robot_users = (
        select distinct UserID
        from $data
        where IsRobot != 0
    );

    insert into $dst_path
        with truncate
    select UserID, UserIDType, IsRobot, UTCEventTime as `Timestamp`
    from $data
    where UserID in $robot_users
    order by UserID, UserIDType, IsRobot

end define;

evaluate for $day in $src_days do
    begin
        evaluate if not ListHas($dst_days, $day) do
            $copy_logs($day)
    end do
else 
    do empty_action();
