#pragma once

#include <mapreduce/yt/interface/client.h>

constexpr const char *F_FORECASTED_BID      = "ForecastedBid";
constexpr const char *F_FORECASTED_BUDGET   = "ForecastedBudget";
constexpr const char *F_FORECASTED_CLICKS   = "ForecastedClicks";
constexpr const char *F_FORECASTED_SHOWS    = "ForecastedShows";

constexpr const char *F_FORECASTER_BUDGET   = "budget";
constexpr const char *F_FORECASTER_QUERIES  = "queries";
constexpr const char *F_FORECASTER_REGIONS  = "regions";

constexpr const char *F_QUERY               = "Query";
constexpr const char *F_REGION_ID           = "RegionId";

namespace NWebmaster {
namespace NForecaster {

struct TForecastTable {
    const char *ATTR_AWAITING_FORECAST = "awaiting_forecast";

    TForecastTable(NYT::IClientBasePtr client, const TString &toForecasterPrefix, const TString &fromForecasterPrefix, const TString &tablePrefix = "queries");

    bool IsForecastPending() const;
    TString GetSourceTable() const;
    TString GetForecastTable() const;
    bool IsThereForecast() const;
    TString PostTableToForecast(NYT::ITransactionPtr tx);
    void Reset(NYT::ITransactionPtr tx);

public:
    NYT::IClientBasePtr Client;
    time_t Timestamp = 0;
    bool Awaiting = false;
    TString ToForecasterPrefix;
    TString FromForecasterPrefix;
    TString TablePrefix;
    TString ForecasterAttr;
};

struct TMapQueriesFromForecaster : public NYT::IMapper<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NYT::TNode>> {
    void Do(TReader *input, TWriter *output) override;
};

struct TReduceJoinForecatedData : public NYT::IReducer<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NYT::TNode>> {
    //reduce by Query, RegionId
    void Do(TReader *input, TWriter *output) override;
};

struct TReduceQueriesToForecaster : public NYT::IReducer<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NYT::TNode>> {
    //reduce by Query, RegionId
    void Do(TReader *input, TWriter *output) override;
};

NYT::TTableSchema GetToForecasterSchema();

} //namespace NForecaster
} //namespace NWebmaster
