#pragma once

#include <util/digest/fnv.h>
#include <util/draft/datetime.h>
#include <util/generic/hash_set.h>
#include <util/generic/map.h>
#include <util/generic/set.h>

#include <kernel/hosts/owner/owner.h>

#include <wmconsole/version3/protos/queries2.pb.h>
#include <wmconsole/version3/wmcutil/regex.h>
#include <wmconsole/version3/wmcutil/serialize.h>
#include <wmconsole/version3/wmcutil/url.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>

#include "config.h"
#include "host2vec.h"

namespace NWebmaster {
namespace NRecommendedUC2 {

struct TTablePathConfig {
    TTablePathConfig(const TString &queriesRoot, const TString &tmpRoot)
        : config_URLCLUSTER_ROOT_QUERIES(queriesRoot)
        , config_URLCLUSTER_ROOT_TMP(tmpRoot)
    {
    }

    #define DEFINE_CONFIG_QUERIES(name, suffix) TString name(const TString &tableName) { return NYTUtils::JoinPath(config_URLCLUSTER_ROOT_QUERIES, tableName, suffix); }
    #define DEFINE_CONFIG_TMP(name, suffix)     TString name(const TString &tableName) { return NYTUtils::JoinPath(config_URLCLUSTER_ROOT_TMP, tableName, suffix); }
    DEFINE_CONFIG_TMP(URLCLUSTER_OWNERS_INFO, "owners-info")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_EXTRACTED, "extracted")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FILTERED_BY_OWNERS, "filtered-by-owners")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_INFO, "queries-info")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_OWNERS_FILTER, "owners-filter")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_QRU, "unique-qru")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_OQR, "unique-oqr-new")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_OUR, "unique-our-new")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FOREIGN, "foreign-queries-3")
    DEFINE_CONFIG_TMP(URLCLUSTER_URLS_FOREIGN, "foreign-urls")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_INFO_QRU, "queries-info-qru")
    DEFINE_CONFIG_TMP(URLCLUSTER_URLS_INFO, "urls-info")
    #undef DEFINE_CONFIG_QUERIES
    #undef DEFINE_CONFIG_TMP

public:
    TString config_URLCLUSTER_ROOT_QUERIES;
    TString config_URLCLUSTER_ROOT_TMP;
};

void TaskRecomendedUCQueries(const TConfig &config);

} //namespace NRecommendedUC2
} //namespace NWebmaster
