#pragma once

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/processors/user_sessions/protos/reports.pb.h>

namespace NWebmaster {
namespace NReports {

//ReduceBy key
//SortBy key, subkey
struct TRecordsLimitCombineReducer : public NYT::IReducer<NYT::TTableReader<NProto::TTopUrlReport>, NYT::TTableWriter<NProto::TTopUrlReport>> {
    Y_SAVELOAD_JOB(Limit)

    TRecordsLimitCombineReducer() = default;
    TRecordsLimitCombineReducer(int limit)
        : Limit(limit)
    {
    }

    void Do(TReader *input, TWriter *output) override {
        for (int i = 0; input->IsValid() && i < Limit; input->Next(), i++) {
            output->AddRow(input->GetRow());
        }
    }

public:
    int Limit = 0;
};

} //namespace NReports
} //namespace NWebmaster
