#include <library/cpp/getopt/modchooser.h>

#include <wmconsole/version3/processors/user_sessions/conf/config.h>
#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include <wmconsole/version3/wmcutil/url.h>

#include "task_archive.h"
#include "task_groups.h"
#include "task_hosts.h"
#include "task_last.h"
#include "task_queries.h"
#include "task_trends2.h"
#include "task_urls.h"

namespace NWebmaster {

void LogInfo(const TString &msg) {
    LOG_INFO("%s", msg.data());
}

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    using namespace NWebmaster;
    using namespace NWebmaster::NReports;
    using namespace NWebmaster::NTrends2;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TModChooser modChooser;
    modChooser.AddMode("UpdateHosts",       TaskUpdateHosts,            "TaskUpdateHosts");
    modChooser.AddMode("Archives",          TaskArchives,               "TaskArchives");
    modChooser.AddMode("Groups",            TaskQueryGroups,            "TaskQueryGroups");
    modChooser.AddMode("LastQueries",       TaskLastQueries,            "TaskLastQueries");
    modChooser.AddMode("TopQueries",        TaskFavoriteAndTopQueries,  "TaskFavoriteAndTopQueries");
    modChooser.AddMode("TopUrls",           TaskFavoriteAndTopUrls,     "TaskFavoriteAndTopUrls");
    modChooser.AddMode("TrendsSnapshot",    TaskTrendsUpdateSnapshot,   "TaskTrendsUpdateSnapshot");
    modChooser.AddMode("Trends",            TaskTrendsUpdateTrends,     "TaskTrendsUpdateTrends");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());

    TCustomYTEnvironment::Instance().Init(envRoot);

    TLogger::Instance();
    NYTUtils::DisableLogger();

    return modChooser.Run(modeArgs);
}
