#pragma once

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/processors/user_sessions/protos/reports.pb.h>
#include <wmconsole/version3/processors/user_sessions/protos/user_sessions.pb.h>

namespace NWebmaster {
namespace NReports {

struct TAttrName {
    static constexpr char const Timestamps[] = "timestamps";
};

struct TArchiveCounter {
    void Add(const NUserSessions::NProto::TQuery &row) {
        Clicks  += row.GetClicks();
        Shows   += row.GetShows();
        ShowsPositionProduct += row.GetShows() * (row.GetPosition() + 1.0);
    }

    void Add(const NProto::TArchiveRecord &row) {
        Clicks  += row.GetClicks();
        Shows   += row.GetShows();
        ShowsPositionProduct += row.GetShowsPositionProduct();
    }

    void Serialize(NProto::TArchiveRecord &record) const {
        record.SetClicks(Clicks);
        record.SetShows(Shows);
        record.SetShowsPositionProduct(ShowsPositionProduct);
    }

    bool IsEmpty() const {
        return Clicks == 0 && Shows == 0;
    }

public:
    size_t Clicks   = 0;
    size_t Shows    = 0;
    double ShowsPositionProduct = 0.0;
};

int TaskArchives(int, const char **);

} //namespace NReports
} //namespace NWebmaster
