#include <util/generic/set.h>

#include <mapreduce/yt/interface/protos/yamr.pb.h>
#include <robot/library/yt/static/command.h>

#include <wmconsole/version3/processors/user_sessions/conf/config.h>
#include <wmconsole/version3/processors/user_sessions/protos/reports.pb.h>
#include <wmconsole/version3/wmcutil/yt/triggers.h>

#include "task_hosts.h"

namespace NWebmaster {
namespace NReports {

using namespace NJupiter;

void LoadWebmasterHosts(NYT::IClientBasePtr client, THashSet<TString> &webmasterHosts) {
    auto reader = TTable<NProto::THost>(client, TConfig::CInstance().TABLE_REPORTS_WEBMASTER_HOSTS).GetReader();
    for (; reader->IsValid(); reader->Next()) {
        webmasterHosts.insert(reader->GetRow().GetHost());
    }
}

int TaskUpdateHosts(int, const char **) {
    const int UPDATE_PERIOD_SECONDS = 3600 * 6; //6 hours
    const auto &cfg = TConfig::CInstance();
    NYT::IClientPtr client = NYT::CreateClient(TCommonYTConfigSQ::CInstance().MR_SERVER_HOST_USER_SESSIONS);

    TYtTimeTrigger trigger(client, cfg.TABLE_REPORTS_WEBMASTER_HOSTS, UPDATE_PERIOD_SECONDS);
    if (!trigger.NeedUpdate()) {
        LOG_INFO("reports, hosts is already updated %s", cfg.TABLE_REPORTS_WEBMASTER_HOSTS.c_str());
        return 0;
    }

    LOG_INFO("reports, updating %s", cfg.TABLE_REPORTS_WEBMASTER_HOSTS.c_str());
    NYT::ITransactionPtr tx = client->StartTransaction();
    TSet<TString> webmasterHostsSorted;
    auto reader = TTable<NYT::TYamr>(tx, cfg.TABLE_SOURCE_WEBMASTER_HOSTS).GetReader();
    for (; reader->IsValid(); reader->Next()) {
        webmasterHostsSorted.insert(reader->GetRow().GetKey());
    }

    if (webmasterHostsSorted.empty()) {
        ythrow yexception() << "webmaster hosts table is empty";
    }

    auto writer = TTable<NProto::THost>(tx, cfg.TABLE_REPORTS_WEBMASTER_HOSTS).AsSortedOutput({"Host"}).GetWriter();
    NProto::THost dstMsg;
    for (const TString &host : webmasterHostsSorted) {
        dstMsg.SetHost(host);
        writer->AddRow(dstMsg);
    }
    writer->Finish();
    trigger.Update(tx);

    tx->Commit();
    LOG_INFO("reports, updating %s - done", cfg.TABLE_REPORTS_WEBMASTER_HOSTS.c_str());

    return 0;
}

} //namespace NReports
} //namespace NWebmaster
