#!/bin/bash

PROGRAM=searchqueries-mr

BIN_DIR=$(dirname $0)
LOCAL_CONFIG=$BIN_DIR/$PROGRAM.$ENV_TYPE.properties
GLOBAL_CONFIG=$BIN_DIR/$PROGRAM.$ENV_TYPE.properties
RUN_DIR=$BIN_DIR
LOG_DIR=/place/db/www/logs

LoadConfig() {
    for line in `cat $1 | awk -F'=' -v OFS='=' '{ gsub(/\./, "_", $1); print}'`; do
        eval "$line"
    done;
}

LoadConfig $GLOBAL_CONFIG

export CONFIG_DISABLE_LOG=true
export MR_RUNTIME=YT
#export YT_TOKEN=$yt_token #will be retrieved from Cloud secret vault
export YT_SPEC=`printf '{ "pool": "%s", "job_io": {"table_writer": {"max_row_weight": 134217728}}, "map_job_io": {"table_writer": {"max_row_weight": 134217728}}, "reduce_job_io": {"table_writer": {"max_row_weight": 134217728}}, "sort_job_io": {"table_writer": {"max_row_weight": 134217728}}, "partition_job_io": {"table_writer": {"max_row_weight": 134217728}}, "merge_job_io": {"table_writer": {"max_row_weight": 134217728}}}' $yt_pool`

cd $RUN_DIR
exec $BIN_DIR/$PROGRAM -G $GLOBAL_CONFIG -C $LOCAL_CONFIG -L $LOG_DIR/current-webmaster-searchqueries-mr-$IPORT $*
