#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/env/yt.h>

namespace NWebmaster {

struct TCommonYTConfigSQ {
    static const TCommonYTConfigSQ &CInstance() {
        return *Singleton<TCommonYTConfigSQ>();
    }

    TCommonYTConfigSQ() {
        const TProdYTEnvironment prodEnv;
        const TProdYTEnvironment custEnv;

        MR_SERVER_HOST_USER_SESSIONS                    = "arnold.yt.yandex.net";

        TABLE_SOURCE_METRIKA_VISIT_LOG_ROOT             = "//logs/visit-v2-log/1d";
        TABLE_SOURCE_METRIKA_VISIT_PRIVATE_LOG_ROOT     = "//logs/visit-v2-private-log/1d";
        TABLE_SOURCE_USER_SESSIONS_DAILY_ROOT           = "//user_sessions/pub/search/daily";
        TABLE_SOURCE_USER_SESSIONS_FAST_ROOT            = "//user_sessions/pub/search/fast";
        TABLE_PARSED_USER_SESSIONS_ROOT                 = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "searchqueries", "user_sessions");
        TABLE_PARSED_USER_SESSIONS_ROBOTS_METRIKA_ROOT  = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_ROOT, "robots", "metrika");
        TABLE_PARSED_USER_SESSIONS_DAILY_ROOT           = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_ROOT, "daily");
        TABLE_PARSED_USER_SESSIONS_FAST_ROOT            = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_ROOT, "fast");
        TABLE_PARSED_USER_SESSIONS_STATS_ROOT           = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_ROOT, "statistics");
        TABLE_PARSED_USER_SESSIONS_STATS_DAILY_ROOT     = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_STATS_ROOT, "daily");
        TABLE_PARSED_USER_SESSIONS_STATS_FAST_ROOT      = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_STATS_ROOT, "fast");

        TABLE_PARSED_USER_SESSIONS_REF_ROOT             = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_ROOT, "reference");
        TABLE_PARSED_USER_SESSIONS_REF_METRIKA_ROOT     = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_REF_ROOT, "metrika");
        TABLE_PARSED_USER_SESSIONS_REF_STATS            = NYTUtils::JoinPath(TABLE_PARSED_USER_SESSIONS_REF_ROOT, "statistics");

        TABLE_CONVERTED_QUERIES_V4_ROOT                 = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "searchqueries", "converted_v4");
    }

public:
    TString MR_SERVER_HOST_USER_SESSIONS;

    TString TABLE_SOURCE_METRIKA_VISIT_LOG_ROOT;
    TString TABLE_SOURCE_METRIKA_VISIT_PRIVATE_LOG_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_DAILY_ROOT;
    TString TABLE_SOURCE_USER_SESSIONS_FAST_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_DAILY_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_FAST_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_ROBOTS_METRIKA_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_STATS_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_STATS_DAILY_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_STATS_FAST_ROOT;

    TString TABLE_PARSED_USER_SESSIONS_REF_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_REF_METRIKA_ROOT;
    TString TABLE_PARSED_USER_SESSIONS_REF_STATS;

    TString TABLE_CONVERTED_QUERIES_V4_ROOT;
};

} //namespace NWebmaster
