#include <util/datetime/base.h>
#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/searchqueries-mr/conf/yt.h>

#include "config.h"

namespace NWebmaster {

const TString TConfig::MSG_APPLICATION_NAME         = "webmaster-searchqueries";
const TString TConfig::MSG_APPLICATION_VERSION      = TConfig::GetProgramRevision();

bool TConfig::IgnoreChecks = false;

void TConfig::Load() {
    TConfigBase::Load();
    Assign(YT_ENV,  "yt.env");

    TCustomYTEnvironment::Instance().Init(YT_ENV);

    Assign(MONITOR_PERFORMANCE_SUFFIX,  "monitor.performance.suffix");
    Assign(PERIODIC_LOG_HANDLER,        "periodic.log.handler");

    Assign(MR_SERVER_HOST_QUERIES,  "mapreduce.server.host.queries");
    Assign(MR_SERVER_HOST_TEXTS,    "mapreduce.server.host.texts");
    Assign(MR_SERVER_HOST_MAIN,     "mapreduce.server.host.main");
    MR_SERVER_HOST_USER_SESSIONS                    = "arnold.yt.yandex.net";

    TABLE_EXPORT_ROOT                               = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;
    TABLE_QUERIES_ROOT                              = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "searchqueries");
    TABLE_TEMP_ROOT                                 = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_TEMP_ROOT, "searchqueries");

    Assign(TABLE_SOURCE_WEBMASTER_HOSTS,            "table.source.webmaster_hosts.prefix");
    Assign(TABLE_SOURCE_QUERIES_CONVERTED_PREFIX,   "table.source.queries.converted.prefix");
    Assign(TABLE_SOURCE_QUERIES_GROUPS_PREFIX,      "table.source.queries.groups.prefix");
    Assign(TABLE_SOURCE_WORDSTAT_CONVERTED_PREFIX,  "table.source.wordstat.converted.prefix");

    TABLE_SOURCE_GROUPS_SETTINGS                    = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_USER_ROOT, "query_groups");
    TABLE_SOURCE_USER_URLS                          = TCommonYTConfig::CInstance().TABLE_SOURCE_USER_URLS;

    Assign(TABLE_QUERIES_CONVERT_ENABLED,   "table.queries.convert.enabled");
    TABLE_QUERIES_STORE_PERIOD                      = 100;

    Assign(TABLE_EVAL_HISTORY,              "table.eval.history");
    Assign(TABLE_EVAL_REPORT,               "table.eval.report");
    Assign(TABLE_EVAL_REPORT_WEBMASTER,     "table.eval.report.webmaster");
    Assign(TABLE_EVAL_REPORT_TARGET,        "table.eval.report.target");
    Assign(TABLE_EVAL_REPORT_DAILY_ANOMALY, "table.eval.report.daily_anomaly");

    Assign(TABLE_SIGNED_CONVERTED, "table.digest.converted");

    Assign(TABLE_DIFF_HISTORY,  "table.diff.history");
    Assign(TABLE_DIFF_REPORT,   "table.diff.report");

    TABLE_REPORTS_ROOT                              = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "reports_v4");
    TABLE_REPORTS_LAST_QUERIES                      = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "last_queries");
    TABLE_REPORTS_TOP_QUERIES                       = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "top_3month.top");
    TABLE_REPORTS_TOP_URLS                          = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "top_urls");
    TABLE_REPORTS_WEBMASTER_HOSTS                   = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "webmaster-hosts");

    TABLE_REPORTS_FAVORITE_QUERIES                  = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_queries");
    TABLE_REPORTS_FAVORITE_QUERIES_SETTINGS         = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_queries_settings");
    TABLE_REPORTS_FAVORITE_URLS                     = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_urls");
    TABLE_REPORTS_FAVORITE_URLS_SETTINGS            = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "favorite_urls_settings");

    TABLE_ARCHIVE_INTM_FULL                         = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "archive-intm");
    TABLE_ARCHIVE_INTM_QUERIES                      = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "archive-intm-queries");
    TABLE_ARCHIVE_ROOT                              = NYTUtils::JoinPath(TABLE_REPORTS_ROOT, "archives");
    TABLE_ARCHIVE_CLICKS                            = NYTUtils::JoinPath(TABLE_ARCHIVE_ROOT, "clicks");
    TABLE_ARCHIVE_SHOWS                             = NYTUtils::JoinPath(TABLE_ARCHIVE_ROOT, "shows");
    TABLE_ARCHIVE_AVG_POSITION                      = NYTUtils::JoinPath(TABLE_ARCHIVE_ROOT, "avg-position");

    Assign(TABLE_RECOMMENDED_FORECASTER_SUFFIX, "table.recommended.forecaster_suffix");
    TABLE_RECOMMENDED_SOURCE_HOSTS                  = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "direct-suggest-hosts");
    TABLE_RECOMMENDED_ROOT                          = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "direct");
    TABLE_RECOMMENDED_QUERIES_TO_FORECASTER         = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "offline_pkz", TABLE_RECOMMENDED_FORECASTER_SUFFIX);
    TABLE_RECOMMENDED_QUERIES_FROM_FORECASTER       = NYTUtils::JoinPath("//home/advq/advq/offline_pkz/output/webmaster", TABLE_RECOMMENDED_FORECASTER_SUFFIX);

    TABLE_RECOMMENDED_TEMP_ROOT                     = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "recommended");
    TABLE_RECOMMENDED_ENRICHED_GROUPS               = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "enriched_groups");
    TABLE_RECOMMENDED_ENRICHED_QUERIES              = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "enriched_queries");
    TABLE_RECOMMENDED_EXTRACTED_QUERIES             = NYTUtils::JoinPath(TABLE_RECOMMENDED_TEMP_ROOT, "extracted_queries");
    TABLE_RECOMMENDED_EXTRACTED_QUERIES_FILTER      = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "extracted_queries_filter");
    TABLE_RECOMMENDED_FORECASTED_GROUPS             = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "forecasted_groups");
    TABLE_RECOMMENDED_IDS_METADESCRS                = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_metadescrs");
    TABLE_RECOMMENDED_IDS_QUERIES                   = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_queries");
    TABLE_RECOMMENDED_IDS_TITLES                    = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_titles");
    TABLE_RECOMMENDED_IDS_URLS                      = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "ids_urls");
    TABLE_RECOMMENDED_INTM_ENRICHED_GROUPS          = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "intermediate/enriched_groups");
    TABLE_RECOMMENDED_INTM_RAW_GROUPS               = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "intermediate/raw_groups");
    TABLE_RECOMMENDED_SOURCE_HOST2VEC               = NYTUtils::JoinPath(TABLE_RECOMMENDED_ROOT, "host2vec");
    TABLE_RECOMMENDED_SOURCE_HOST2VEC_GROUPS        = TABLE_RECOMMENDED_SOURCE_HOST2VEC + ".g";
    TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOST_GROUPS   = TABLE_RECOMMENDED_SOURCE_HOST2VEC + ".hg";
    TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOSTS         = TABLE_RECOMMENDED_SOURCE_HOST2VEC + ".h";
    Assign(RECOMMENDED_ENABLED_BUILD_DATA, "recommended_enabled_build_data");

    Assign(CATALOGIA_ENABLED_BUILD_TITLES,  "catalogia_enabled_build_titles");
    Assign(CATALOGIA_ENABLED_BUILD_DATA,    "catalogia_enabled_build_data");

    FILE_CATALOGIA_MIRRORS_TRIE                     = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "mirrors.trie");
    TABLE_CATALOGIA_EXPORT_ROOT                     = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "catalogia");
    TABLE_CATALOGIA_WORK_ROOT                       = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "direct");
    TABLE_CATALOGIA_EXPORT_LINKS_INT                = NYTUtils::JoinPath(TABLE_CATALOGIA_EXPORT_ROOT, "links");
    TABLE_CATALOGIA_EXPORT_QUERIES                  = NYTUtils::JoinPath(TABLE_CATALOGIA_EXPORT_ROOT, "queries");
    TABLE_CATALOGIA_EXTRACTED_QUERIES               = NYTUtils::JoinPath(TABLE_CATALOGIA_WORK_ROOT, "catalogia_queries");
    TABLE_CATALOGIA_MIRRORS                         = NYTUtils::JoinPath(TABLE_CATALOGIA_WORK_ROOT, "mirrors");
    TABLE_CATALOGIA_ROBOTS                          = NYTUtils::JoinPath(TABLE_CATALOGIA_WORK_ROOT, "catalogia_robots");
    TABLE_CATALOGIA_SOURCE_TEXTS                    = NYTUtils::JoinPath(TABLE_CATALOGIA_WORK_ROOT, "texts");
    TABLE_CATALOGIA_SOURCE_DOMAINS                  = "//home/bannerland/data/dse/preparing/dyn-perf-domains";

    TABLE_CATALOGIA2_ROOT                           = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "catalogia2");
    TABLE_CATALOGIA2_TMP_ROOT                       = NYTUtils::JoinPath(/*TABLE_TEMP_ROOT*/ "//home/webmaster/prod/tmp", "catalogia2");
    TABLE_CATALOGIA2_HITS_MONTHLY                   = NYTUtils::JoinPath(TABLE_CATALOGIA2_ROOT, "hits", "monthly");
    TABLE_CATALOGIA2_HITS_DAILY                     = NYTUtils::JoinPath(TABLE_CATALOGIA2_ROOT, "hits", "daily");

    Assign(TABLE_AUTOCAMPAIGN_SOURCE_DOMAINS,   "table.autocampaign.source.domains");
    Assign(TABLE_AUTOCAMPAIGN_EXPORT_GROUPS,    "table.autocampaign.export.groups");
    Assign(TABLE_AUTOCAMPAIGN_ROOT,             "table.autocampaign.root");
    TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES            = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "extracted_queries");
    TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES_FILTER     = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "extracted_queries_filter");
    TABLE_AUTOCAMPAIGN_ENRICHED_QUERIES             = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "enriched_queries");
    TABLE_AUTOCAMPAIGN_IDS_QUERIES                  = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "ids_queries");
    TABLE_AUTOCAMPAIGN_IDS_URLS                     = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "ids_urls");
    TABLE_AUTOCAMPAIGN_INTM_RAW_GROUPS              = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "intermediate/raw_groups");
    TABLE_AUTOCAMPAIGN_INTM_ENRICHED_GROUPS         = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "intermediate/enriched_groups");
    TABLE_AUTOCAMPAIGN_ENRICHED_GROUPS              = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "enriched_groups");
    TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC              = NYTUtils::JoinPath(TABLE_AUTOCAMPAIGN_ROOT, "host2vec");
    TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_GROUPS       = TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC + ".g";
    TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOST_GROUPS  = TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC + ".hg";
    TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOSTS        = TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC + ".h";

    Assign(TABLE_RIVALS_QUERIES_ROOT, "table.rivals.root");
    TABLE_RIVALS_QUERIES_HOST2VEC_ROOT              = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_ROOT, "host2vec");
    TABLE_RIVALS_QUERIES_HOST2VEC_HOST2VEC          = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "host2vec");
    TABLE_RIVALS_QUERIES_HOST2VEC_GROUPS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "groups");
    TABLE_RIVALS_QUERIES_HOST2VEC_HOST_GROUPS       = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "host_groups");
    TABLE_RIVALS_QUERIES_HOST2VEC_HOSTS             = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_HOST2VEC_ROOT, "hosts");
    TABLE_RIVALS_QUERIES_REPORT_ROOT                = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_ROOT, "report");
    TABLE_RIVALS_QUERIES_TMP_ROOT                   = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "rivals");
    TABLE_RIVALS_QUERIES_TMP_EXTRACTED_QUERIES      = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_TMP_ROOT, "queries");
    TABLE_RIVALS_QUERIES_TMP_RAW_GROUPS             = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_TMP_ROOT, "groups");
    TABLE_RIVALS_QUERIES_TMP_HOST_COUNTERS          = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES_TMP_ROOT, "host_counters");

    Assign(TABLE_RIVALS_QUERIES2_ROOT, "table.rivals2.root");
    TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT             = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_ROOT, "host2vec");
    TABLE_RIVALS_QUERIES2_HOST2VEC_HOST2VEC         = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "host2vec");
    TABLE_RIVALS_QUERIES2_HOST2VEC_GROUPS           = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "groups");
    TABLE_RIVALS_QUERIES2_HOST2VEC_HOST_GROUPS      = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "host_groups");
    TABLE_RIVALS_QUERIES2_HOST2VEC_HOSTS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT, "hosts");
    TABLE_RIVALS_QUERIES2_HOST_COUNTERS_ROOT        = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_ROOT, "host_counters");
    TABLE_RIVALS_QUERIES2_REPORT_ROOT               = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_ROOT, "report");
    TABLE_RIVALS_QUERIES2_TMP_ROOT                  = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "rivals_v2");
    TABLE_RIVALS_QUERIES2_TMP_EXTRACTED_QUERIES     = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "queries");
    TABLE_RIVALS_QUERIES2_TMP_RAW_GROUPS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "groups");
    TABLE_RIVALS_QUERIES2_TMP_HOST_COUNTERS         = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "host_counters");
    TABLE_RIVALS_QUERIES2_TMP_DAY_TRENDS            = NYTUtils::JoinPath(TABLE_RIVALS_QUERIES2_TMP_ROOT, "day_trends");

    Assign(TABLE_RECOMMENDED_UC2_QUERIES_FROM_FORECASTER,   "table.recommended_uc.from_forecaster");
    Assign(TABLE_RECOMMENDED_UC2_QUERIES_TO_FORECASTER,     "table.recommended_uc.to_forecaster");

    TABLE_RECOMMENDED_UC2_ROOT                      = NYTUtils::JoinPath(TABLE_QUERIES_ROOT, "direct", "extended");
    TABLE_RECOMMENDED_UC2_HOSTS_PREPARED            = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "hosts");
    TABLE_RECOMMENDED_UC2_QUERIES_EXTRACTED         = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "extracted");
    TABLE_RECOMMENDED_UC2_QUERIES                   = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "queries");
    TABLE_RECOMMENDED_UC2_QUERIES_FORECASTED        = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "forecasted");
    TABLE_RECOMMENDED_UC2_QUERIES_PREPARED          = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "prepared");
    TABLE_RECOMMENDED_UC2_TMP_ROOT                  = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "direct", "extended");
    TABLE_RECOMMENDED_UC2_URLS                      = NYTUtils::JoinPath(TABLE_RECOMMENDED_UC2_ROOT, "urls");

    Assign(TABLE_SOURCE_RADAR_ROOT, "table.trends2.source.radar.root");
    Assign(TABLE_TRENDS2_ROOT,      "table.trends2.root");
    TABLE_TRENDS2_INTM                              = NYTUtils::JoinPath(TABLE_TRENDS2_ROOT, "intermediate");
    TABLE_TRENDS2_SNAPSHOT                          = NYTUtils::JoinPath(TABLE_TRENDS2_ROOT, "snapshot");
    TABLE_TRENDS2_TRENDS                            = NYTUtils::JoinPath(TABLE_TRENDS2_ROOT, "trends");
    TABLE_TRENDS2_SNAPSHOT_LOG                      = TABLE_TRENDS2_SNAPSHOT + "-log";
}

} //namespace NWebmaster
