#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/wmcutil/config_base.h>
#include <wmconsole/version3/wmcutil/http_client.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TConfig : TConfigBase {
    void Load() override;

    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

public:
    static const TString MSG_APPLICATION_NAME;
    static const TString MSG_APPLICATION_VERSION;

    static bool IgnoreChecks;

public:
    const float OPERATION_WEIGHT = 1.0f;
    static constexpr const char *GEOBASE_FILE_LITE = "geodata4-tree+ling.bin";

    TString YT_ENV;
    TString MR_SERVER_HOST_TEXTS;
    TString MR_SERVER_HOST_MAIN;
    TString MR_SERVER_HOST_QUERIES;
    TString MR_SERVER_HOST_USER_SESSIONS;

    bool TABLE_QUERIES_CONVERT_ENABLED;

    TString TABLE_SOURCE_WEBMASTER_HOSTS;

    size_t TABLE_QUERIES_STORE_PERIOD;

    TString TABLE_SOURCE_GROUPS_SETTINGS;
    TString TABLE_SOURCE_QUERIES_RAW_SRC_PREFIX;
    TString TABLE_SOURCE_QUERIES_RAW_REGEX;
    TString TABLE_SOURCE_QUERIES_CONVERTED_PREFIX;
    TString TABLE_SOURCE_QUERIES_GROUPS_PREFIX;
    TString TABLE_SOURCE_WORDSTAT_CONVERTED_PREFIX;
    TString TABLE_SOURCE_USER_URLS;

    TString TABLE_TEMP_ROOT;
    TString TABLE_EXPORT_ROOT;

    TString TABLE_QUERIES_ROOT;
    TString TABLE_CATALOGIA2_ROOT;
    TString TABLE_CATALOGIA2_TMP_ROOT;
    TString TABLE_CATALOGIA2_HITS_MONTHLY;
    TString TABLE_CATALOGIA2_HITS_DAILY;

    TString TABLE_REPORTS_ROOT;
    TString TABLE_REPORTS_FAVORITE_QUERIES;
    TString TABLE_REPORTS_FAVORITE_QUERIES_SETTINGS;
    TString TABLE_REPORTS_FAVORITE_URLS;
    TString TABLE_REPORTS_FAVORITE_URLS_SETTINGS;
    TString TABLE_REPORTS_TOP_QUERIES;
    TString TABLE_REPORTS_TOP_URLS;
    TString TABLE_REPORTS_WEBMASTER_HOSTS;

    TString TABLE_REPORTS_LAST_QUERIES;

    TString TABLE_ARCHIVE_INTM_FULL;
    TString TABLE_ARCHIVE_INTM_QUERIES;
    TString TABLE_ARCHIVE_ROOT;
    TString TABLE_ARCHIVE_CLICKS;
    TString TABLE_ARCHIVE_SHOWS;
    TString TABLE_ARCHIVE_AVG_POSITION;

    TString TABLE_EVAL_HISTORY;
    TString TABLE_EVAL_REPORT;
    TString TABLE_EVAL_REPORT_WEBMASTER;
    TString TABLE_EVAL_REPORT_TARGET;
    TString TABLE_EVAL_REPORT_DAILY_ANOMALY;

    TString TABLE_DIFF_HISTORY;
    TString TABLE_DIFF_REPORT;

    TString TABLE_SIGNED_CONVERTED;

    TString TABLE_RECOMMENDED_FORECASTER_SUFFIX;
    bool RECOMMENDED_ENABLED_BUILD_DATA;
    TString TABLE_RECOMMENDED_ROOT;
    TString TABLE_RECOMMENDED_TEMP_ROOT;
    TString TABLE_RECOMMENDED_ENRICHED_GROUPS;
    TString TABLE_RECOMMENDED_ENRICHED_QUERIES;
    TString TABLE_RECOMMENDED_EXTRACTED_QUERIES_FILTER;
    TString TABLE_RECOMMENDED_EXTRACTED_QUERIES;
    TString TABLE_RECOMMENDED_FORECASTED_GROUPS;
    TString TABLE_RECOMMENDED_IDS_METADESCRS;
    TString TABLE_RECOMMENDED_IDS_QUERIES;
    TString TABLE_RECOMMENDED_IDS_TITLES;
    TString TABLE_RECOMMENDED_IDS_URLS;
    TString TABLE_RECOMMENDED_INTM_ENRICHED_GROUPS;
    TString TABLE_RECOMMENDED_INTM_RAW_GROUPS;
    TString TABLE_RECOMMENDED_QUERIES_FROM_FORECASTER;
    TString TABLE_RECOMMENDED_QUERIES_TO_FORECASTER;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC_GROUPS;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOST_GROUPS;
    TString TABLE_RECOMMENDED_SOURCE_HOST2VEC_HOSTS;
    TString TABLE_RECOMMENDED_SOURCE_HOSTS;

    bool CATALOGIA_ENABLED_BUILD_DATA;
    bool CATALOGIA_ENABLED_BUILD_TITLES;

    TString FILE_CATALOGIA_MIRRORS_TRIE;
    TString TABLE_CATALOGIA_EXPORT_ROOT;
    TString TABLE_CATALOGIA_WORK_ROOT;
    TString TABLE_CATALOGIA_EXPORT_LINKS_INT;
    TString TABLE_CATALOGIA_EXPORT_QUERIES;
    TString TABLE_CATALOGIA_EXTRACTED_QUERIES;
    TString TABLE_CATALOGIA_MIRRORS;
    TString TABLE_CATALOGIA_ROBOTS;
    TString TABLE_CATALOGIA_SOURCE_DOMAINS;
    TString TABLE_CATALOGIA_SOURCE_LINKS_PREPARAT;
    TString TABLE_CATALOGIA_SOURCE_TEXTS;

    TString TABLE_AUTOCAMPAIGN_ROOT;
    TString TABLE_AUTOCAMPAIGN_EXPORT_GROUPS;
    TString TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES;
    TString TABLE_AUTOCAMPAIGN_EXTRACTED_QUERIES_FILTER;
    TString TABLE_AUTOCAMPAIGN_ENRICHED_QUERIES;
    TString TABLE_AUTOCAMPAIGN_IDS_QUERIES;
    TString TABLE_AUTOCAMPAIGN_IDS_URLS;
    TString TABLE_AUTOCAMPAIGN_INTM_RAW_GROUPS;
    TString TABLE_AUTOCAMPAIGN_INTM_ENRICHED_GROUPS;
    TString TABLE_AUTOCAMPAIGN_ENRICHED_GROUPS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_GROUPS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOST_GROUPS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_HOST2VEC_HOSTS;
    TString TABLE_AUTOCAMPAIGN_SOURCE_DOMAINS;

    TString MONITOR_PERFORMANCE_SUFFIX;
    TString PERIODIC_LOG_HANDLER;

    TString TABLE_RIVALS_QUERIES_ROOT;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_ROOT;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_HOST2VEC;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_GROUPS;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_HOST_GROUPS;
    TString TABLE_RIVALS_QUERIES_HOST2VEC_HOSTS;
    TString TABLE_RIVALS_QUERIES_REPORT_ROOT;
    TString TABLE_RIVALS_QUERIES_TMP_ROOT;
    TString TABLE_RIVALS_QUERIES_TMP_EXTRACTED_QUERIES;
    TString TABLE_RIVALS_QUERIES_TMP_RAW_GROUPS;
    TString TABLE_RIVALS_QUERIES_TMP_HOST_COUNTERS;

    TString TABLE_RIVALS_QUERIES2_ROOT;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_ROOT;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_HOST2VEC;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_GROUPS;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_HOST_GROUPS;
    TString TABLE_RIVALS_QUERIES2_HOST2VEC_HOSTS;
    TString TABLE_RIVALS_QUERIES2_HOST_COUNTERS_ROOT;
    TString TABLE_RIVALS_QUERIES2_REPORT_ROOT;
    TString TABLE_RIVALS_QUERIES2_TMP_ROOT;
    TString TABLE_RIVALS_QUERIES2_TMP_EXTRACTED_QUERIES;
    TString TABLE_RIVALS_QUERIES2_TMP_RAW_GROUPS;
    TString TABLE_RIVALS_QUERIES2_TMP_HOST_COUNTERS;
    TString TABLE_RIVALS_QUERIES2_TMP_DAY_TRENDS;

    TString TABLE_RECOMMENDED_UC2_QUERIES_FROM_FORECASTER;
    TString TABLE_RECOMMENDED_UC2_QUERIES_TO_FORECASTER;
    TString TABLE_RECOMMENDED_UC2_ROOT;
    TString TABLE_RECOMMENDED_UC2_HOSTS_PREPARED;
    TString TABLE_RECOMMENDED_UC2_QUERIES;
    TString TABLE_RECOMMENDED_UC2_QUERIES_EXTRACTED;
    TString TABLE_RECOMMENDED_UC2_QUERIES_FORECASTED;
    TString TABLE_RECOMMENDED_UC2_QUERIES_PREPARED;
    TString TABLE_RECOMMENDED_UC2_TMP_ROOT;
    TString TABLE_RECOMMENDED_UC2_URLS;

    TString TABLE_SOURCE_RADAR_ROOT;
    TString TABLE_TRENDS2_ROOT;
    TString TABLE_TRENDS2_INTM;
    TString TABLE_TRENDS2_SNAPSHOT;
    TString TABLE_TRENDS2_SNAPSHOT_LOG;
    TString TABLE_TRENDS2_TRENDS;
};

} //namespace NWebmaster
