#pragma once

#include <dict/word2vec/model/model.h>
#include <dict/word2vec/util/analogy/bruteforce/searcher.h>
#include <library/cpp/containers/comptrie/comptrie.h>
#include <library/cpp/tld/tld.h>

#include <mapreduce/yt/interface/client.h>
#include <util/digest/fnv.h>

#include "config.h"

namespace NWebmaster {
namespace NHost2Vec {

constexpr const char *F_HASH    = "Hash";
constexpr const char *F_HOST    = "Host";
constexpr const char *F_GROUP   = "Group";
constexpr const char *F_GROUPS  = "Groups";

struct TTableConfig {
    TTableConfig() = default;
    TTableConfig(const TString &sourceHosts, const TString &hosts2Vec, const TString &hostGroupsHash, const TString &hostsHash, const TString &groupsHash)
        : SourceHosts(sourceHosts)
        , Hosts2Vec(hosts2Vec)
        , HostGroupsHash(hostGroupsHash)
        , HostsHash(hostsHash)
        , GroupsHash(groupsHash)
    {
    }

public:
    const TString SourceHosts;
    const TString Hosts2Vec;
    const TString HostGroupsHash;
    const TString HostsHash;
    const TString GroupsHash;
};

template<class T>
struct TReduceGetColumnHash : public NYT::IReducer<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NYT::TNode>> {
    Y_SAVELOAD_JOB(ReduceBy, HashColumn)

public:
    TReduceGetColumnHash() = default;
    TReduceGetColumnHash(const TString &reduceBy, const TString &hashColumn)
            : ReduceBy(reduceBy)
            , HashColumn(hashColumn)
    {
    }

    void Do(TReader *input, TWriter *output) override {
        const TString reduceByVal = input->GetRow()[ReduceBy].AsString();
        output->AddRow(NYT::TNode()
               (ReduceBy, reduceByVal)
               (HashColumn, FnvHash<T>(reduceByVal.data(), reduceByVal.size()))
        );
    }

public:
    TString ReduceBy;
    TString HashColumn;
};

void GetGroupsHashes(const TString &src, TVector<ui32> &hashes);
void BuildHostToGroupTrie(NYT::IClientBasePtr client, const TString &hostGroupsHashTable, THashMap<TString, TVector<ui32>> &ownerToGroups, TVector<char> &trieStream);
void LoadGroupsHashes(NYT::IClientBasePtr client, const TString &groupsHashTable, THashMap<ui32, TString> &hashToGroup);

void TaskUpdateHost2vecGroups(NYT::IClientBasePtr client, const TString &hostFieldName, const TTableConfig &tables);

} //namespace NHost2Vec
} //namespace NWebmaster
