#pragma once

#include <util/generic/map.h>
#include <util/generic/singleton.h>
#include <library/cpp/deprecated/atomic/atomic.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/monitor_client.h>

namespace NWebmaster {

struct TMonitor : public TMonitorBase {
    TMonitor();

    void Upload() override;

    static TMonitor *Instance() {
        return Singleton<TMonitor>();
    }

public:
    TSensorData HistoryReportSuccess;
    TSensorData HistoryReportFailed;
};

void MonitorPushHistory(const TString &monitorSuffix, const TMap<time_t, TMap<TString, double>> &history, const TString &prefix);
void MonitorSourceTables(const TString &suffix, int mostRecentSourceLag, int holes);

void MonitorPushLabel(const TString &suffix, const TString &label, const TString &service, double value);
void MonitorPushQualityLabel(const TString &suffix, const TString &label, double value);
void MonitorPushCountersLabel(const TString &suffix, const TString &label, double value);

void MonitorAutocampaignDomains(const TString &suffix, size_t domains);
void MonitorAutocampaignQueriesPTime(const TString &suffix, size_t minutes);
void MonitorCatalogiaLinksPTime(const TString &suffix, size_t minutes);
void MonitorCatalogiaQueriesPTime(const TString &suffix, size_t minutes);
void MonitorCatalogiaHosts(const TString &suffix, size_t hosts);

void MonitorToForecasterQueries(const TString &suffix, size_t queries);
void MonitorToForecasterUCQueries(const TString &suffix, size_t queries);

void UpdateHistoryMonitor(NYT::IClientBasePtr client, const TString &suffix, const TString &historyTable, const TString &prefix);

} //namespace NWebmaster
