#!/bin/bash

PROGRAM=searchqueries-mr

ENV_TYPE=`cat /etc/yandex/environment.type`
BIN_DIR=$(dirname $0)
LOCAL_CONFIG=$BIN_DIR/$PROGRAM.$ENV_TYPE.properties
GLOBAL_CONFIG=/etc/yandex/webmaster/configs/wmconsole.$ENV_TYPE.properties
RUN_DIR=/var/lib/yandex/webmaster/searchqueries
LOG_DIR=/var/log/webmaster

LoadConfig() {
    for line in `cat $1 | awk -F'=' -v OFS='=' '{ gsub(/\./, "_", $1); print}'`; do
        eval "$line"
    done;
}

LoadConfig $GLOBAL_CONFIG

if [ ! -z $LOCAL_CONFIG ] && [ -e $LOCAL_CONFIG ]; then
    LoadConfig $LOCAL_CONFIG
fi

export MR_RUNTIME=YT
export YT_TOKEN=$yt_token
export YT_SPEC=`printf '{ "pool": "%s", "job_io": {"table_writer": {"max_row_weight": 134217728}}, "map_job_io": {"table_writer": {"max_row_weight": 134217728}}, "reduce_job_io": {"table_writer": {"max_row_weight": 134217728}}, "sort_job_io": {"table_writer": {"max_row_weight": 134217728}}, "partition_job_io": {"table_writer": {"max_row_weight": 134217728}}, "merge_job_io": {"table_writer": {"max_row_weight": 134217728}}}' $yt_pool`

./$PROGRAM -G $GLOBAL_CONFIG -C $LOCAL_CONFIG -L webmaster-searchqueries-mr.log $* >> webmaster-searchqueries-mr.sh.log 2>> webmaster-searchqueries-mr.sh.err
