#pragma once

#include "config.h"

namespace NWebmaster {
namespace NCatalogia2 {

struct TTablePathConfig {
    TTablePathConfig(const TString &queriesRoot, const TString &tmpRoot, const TString &tableName)
        : config_URLCLUSTER_ROOT_QUERIES(queriesRoot)
        , config_URLCLUSTER_ROOT_TMP(tmpRoot)
        , TableName(tableName)
        , URLCLUSTER_ROOT_QUERIES(NYTUtils::JoinPath(config_URLCLUSTER_ROOT_QUERIES, TableName))
        , URLCLUSTER_ROOT_TMP(NYTUtils::JoinPath(config_URLCLUSTER_ROOT_TMP, TableName))
    {
    }

    #define DEFINE_CONFIG_QUERIES(name, suffix) TString name(const TString &tableName = "") const { return NYTUtils::JoinPath(config_URLCLUSTER_ROOT_QUERIES, tableName.empty() ? TableName : tableName, suffix); }
    #define DEFINE_CONFIG_TMP(name, suffix)     TString name(const TString &tableName = "") const { return NYTUtils::JoinPath(config_URLCLUSTER_ROOT_TMP, tableName.empty() ? TableName : tableName, suffix); }
    DEFINE_CONFIG_TMP(URLCLUSTER_OWNERS_INFO, "owners-info")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_EXTRACTED, "extracted")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FILTERED_BY_OWNERS, "filtered-by-owners")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_INFO, "queries-info")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_OWNERS_FILTER, "owners-filter")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_QRU, "unique-qru")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_OQR, "unique-oqr-new")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_UNIQUE_OUR, "unique-our-new")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FOREIGN, "foreign-queries-3")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_FOREIGN_COUNTER, "foreign-queries-counter")
    DEFINE_CONFIG_TMP(URLCLUSTER_URLS_FOREIGN, "foreign-urls")
    DEFINE_CONFIG_TMP(URLCLUSTER_QUERIES_INFO_QRU, "queries-info-qru")
    DEFINE_CONFIG_TMP(URLCLUSTER_URLS_INFO, "urls-info")
    DEFINE_CONFIG_QUERIES(URLCLUSTER_QUERIES_UNIQUE_OQR_FINAL, "unique-oqr-new")
    DEFINE_CONFIG_QUERIES(URLCLUSTER_QUERIES_UNIQUE_OUR_FINAL, "unique-our-new")
    DEFINE_CONFIG_QUERIES(URLCLUSTER_QUERIES_UNIQUE_OQR_FINAL_STATISTICS, "unique-our-new-statistics")
    #undef DEFINE_CONFIG_QUERIES
    #undef DEFINE_CONFIG_TMP

public:
    TString config_URLCLUSTER_ROOT_QUERIES;
    TString config_URLCLUSTER_ROOT_TMP;
    TString TableName;
    TString URLCLUSTER_ROOT_QUERIES;
    TString URLCLUSTER_ROOT_TMP;
};

inline TTablePathConfig GetPathConfig(const TString &tableName = "one-week") {
    return TTablePathConfig(
        TConfig::CInstance().TABLE_CATALOGIA2_ROOT,
        TConfig::CInstance().TABLE_CATALOGIA2_TMP_ROOT,
        tableName
    );
}

inline bool IsPornoQuery(int upperPornoUpperPl) {
    return upperPornoUpperPl == 100;
}

void TaskBuildCatalogiaQueries(const TConfig &/*config*/);

} //namespace NCatalogia2
} //namespace NWebmaster
