#include <util/datetime/base.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"

namespace NWebmaster {

void TConfig::Load() {
    TConfigBase::Load();

    Assign(MONITOR_PERFORMANCE_SUFFIX,              "monitor.performance.suffix");
    Assign(PERIODIC_LOG_HANDLER,                    "periodic.log.handler");

    Assign(MR_SERVER_HOST_LOGS,                     "mapreduce.server.host.logs");
    Assign(MR_SERVER_HOST_JUPITER,                  "mapreduce.server.host.jupiter");
    Assign(MR_SERVER_HOST_MAIN,                     "mapreduce.server.host.main");

    Assign(FILE_MIRRORS_TRIE_YT_PATH,               "file.mirrors.trie");
    Assign(TABLE_HOST2VEC_TRAIN_DATASET,            "table.host2vec.train.dataset");
    Assign(TABLE_HOST2VEC_TRAIN_DAYS,               "table.host2vec.train.days");

    Assign(FILE_HOST2VEC_MODEL_SIMILARGROUP_ROOT,   "file.host2vec.model.similargroup.root");
    Assign(FILE_HOST2VEC_MODEL_SPY_LOG_ROOT,        "file.host2vec.model.spy_log.root");
    Assign(FILE_HOST2VEC_MODEL_TABLE,               "file.host2vec.model.table");
    Assign(FILE_HOST2VEC_MODEL_WORDS,               "file.host2vec.model.words");
    Assign(FILE_HOST2VEC_MODEL_VECTORS,             "file.host2vec.model.vectors");

    FILE_MIRRORS_TRIE_DISK_PATH = NYTUtils::GetObjectName(FILE_MIRRORS_TRIE_YT_PATH);
}

} //namespace NWebmaster
