#include <util/datetime/base.h>
#include <util/stream/format.h>
#include <util/string/cast.h>
#include <util/string/printf.h>
#include <util/string/strip.h>
#include <util/system/user.h>

#include <library/cpp/getopt/last_getopt.h>

#include <dict/word2vec/model/model.h>
#include <dict/word2vec/util/analogy/bruteforce/searcher.h>

#include "wmconsole/version3/wmcutil/http_server.h"
#include <wmconsole/version3/wmcutil/url.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>

#include "service.h"

bool GetDictHost(const TString &url, TString &host) {
    TString tmp, path;
    if (!NWebmaster::NUtils::SplitUrl(url, tmp, path)) {
        return false;
    }
    tmp.to_lower();
    if (tmp.Contains("http://")) {
        tmp = tmp.substr(7);
    }
    tmp.swap(host);
    return true;
}

TString GetSchemedHost(const TString &host) {
    if (host.Contains("://")) {
        return host;
    }

    return "http://" + host;
}

static volatile bool gRunning = true;

static void OnTerminate(int = 0) {
    gRunning = false;
}

int main(int argc, const char **argv) {
    using namespace NWebmaster;
    Y_UNUSED(argc);
    Y_UNUSED(argv);

    InitNetworkSubSystem();

    // Manage signals
    signal(SIGPIPE, SIG_IGN);
    signal(SIGINT, OnTerminate);
    signal(SIGTERM, OnTerminate);

    Cout << "starting" << Endl;
    //TFileInput fi("vectors");
    //TSimpleSharedPtr<NWord2Vec::TModel> model = NWord2Vec::LoadFromBinary(&fi);
    TSimpleSharedPtr<NWord2Vec::TModel> model = NWord2Vec::LoadFromYandex("words", "vectors");
    Cout << "started" << Endl;
    THost2VecViewerService host2vecService(model);

    NWebmaster::THttpServer httpServer(8170, 4, &host2vecService);

    // Wait for signals
    do {
        sleep(1);
    } while (gRunning);
}
