#pragma once

#include <util/generic/set.h>
#include <util/system/fstat.h>

#include <kernel/hosts/owner/owner.h>
#include <dict/word2vec/model/model.h>
#include <dict/word2vec/util/analogy/bruteforce/searcher.h>


#include <wmconsole/version3/wmcutil/http_server.h>

namespace NWebmaster {

struct THost2VecViewerService : THttpServer::TUserService {
    THost2VecViewerService(TSimpleSharedPtr<NWord2Vec::TModel> model);

    bool MethodAnalogyRequest(THttpServer::TRequest &request);
    bool MethodPing(THttpServer::TRequest &request);

    void *CreateThreadSpecificResource() override;
    void DestroyThreadSpecificResource(void *tsr) override;

public:
private:
    TOwnerCanonizer OwnerCanonizer;
    TSimpleSharedPtr<NWord2Vec::TModel> Model;

    THolder<TSearcher> Searcher;
};

} //namespace NWebmaster
