#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/wmcutil/config_base.h>

namespace NWebmaster {

struct TConfig : TConfigBase {
    void Load() override;

public:
    static TConfig& Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig& CInstance() {
        return Instance();
    }

public:
    TString MR_SERVER_HOST;

    TString TABLE_RAW_STATS_DIR;
    TString TABLE_GROUPS_NAME;
    TString TABLE_WEEKLY_STATS_DIR;
    TString TABLE_WEEKLY_STATS_NAME_PREFIX;
    size_t MAX_RESULT_TABLES_COUNT;

    bool FORCE = false;
    time_t WEEK = 0;
};

} //namespace NWebmaster
