#!/bin/bash

PROGRAM=ya-service-stats

ENV_TYPE=`cat /etc/yandex/environment.type`
BIN_DIR=$(dirname $0)
LOCAL_CONFIG=$BIN_DIR/$PROGRAM.$ENV_TYPE.properties
GLOBAL_CONFIG=/etc/yandex/webmaster/configs/wmconsole.$ENV_TYPE.properties
RUN_DIR=/var/lib/yandex/webmaster/ya-service-stats
LOG_DIR=/var/log/webmaster

LoadConfig() {
    for line in `cat $1 | awk -F'=' -v OFS='=' '{ gsub(/\./, "_", $1); print}'`; do
        eval "$line"
    done;
}

LoadConfig $GLOBAL_CONFIG

if [ ! -z $LOCAL_CONFIG ] && [ -e $LOCAL_CONFIG ]; then
    LoadConfig $LOCAL_CONFIG
fi

export YT_TOKEN=111
export YT_POOL=$yt_pool
export YT_SPEC='{"job_io": {"table_writer": {"max_row_weight": 134217728}}, "map_job_io": {"table_writer": {"max_row_weight": 134217728}}, "reduce_job_io": {"table_writer": {"max_row_weight": 134217728}}, "sort_job_io": {"table_writer": {"max_row_weight": 134217728}}, "partition_job_io": {"table_writer": {"max_row_weight": 134217728}}, "merge_job_io": {"table_writer": {"max_row_weight": 134217728}}}'

cd $RUN_DIR
exec $BIN_DIR/$PROGRAM -G $GLOBAL_CONFIG -C $LOCAL_CONFIG -L $LOG_DIR/webmaster-$PROGRAM.log $* >> $LOG_DIR/webmaster-$PROGRAM.sh.log 2>> $LOG_DIR/webmaster-$PROGRAM.sh.err
