#include <library/cpp/testing/unittest/registar.h>

#include "query_utils.h"

using namespace NWebmaster;

Y_UNIT_TEST_SUITE(TSearchQueriesAutoCampaignTest) {
    Y_UNIT_TEST(AutoCampaignQueryFilter_Test01) {
        TString filteredQuery;
        int flags = 0;
        UNIT_ASSERT(FilterAutoCampaignQuery("query1  query2 3.14/?_;:*&%$№@{}[]±+-§<>\"\'|\\`()^#.,=query5 query6 veryveryveryveryveryveryveryveryverylongquery query7 query8", filteredQuery, flags));
        UNIT_ASSERT_EQUAL(filteredQuery, "query1 query2 3 14 query5 query6 query7");
        UNIT_ASSERT_EQUAL(flags, DFQF_QUERY_RESIZED | DFQF_REMOVED_SYMBOLS | DFQF_REMOVED_LONG_WORDS);

        UNIT_ASSERT(!FilterAutoCampaignQuery("veryveryveryveryveryveryveryveryverylongquery", filteredQuery, flags));

        UNIT_ASSERT(FilterAutoCampaignQuery("query", filteredQuery, flags));
        UNIT_ASSERT_EQUAL(filteredQuery, "query");
        UNIT_ASSERT_EQUAL(flags, 0);

        UNIT_ASSERT(FilterAutoCampaignQuery("query1 veryveryveryveryveryveryveryveryverylongquery query2", filteredQuery, flags));
        UNIT_ASSERT_EQUAL(filteredQuery, "query1 query2");
        UNIT_ASSERT_EQUAL(flags, DFQF_REMOVED_LONG_WORDS);

        UNIT_ASSERT(FilterAutoCampaignQuery("query1 query2 query3 query4 query5 query6 query7 query8", filteredQuery, flags));
        UNIT_ASSERT_EQUAL(filteredQuery, "query1 query2 query3 query4 query5 query6 query7");
        UNIT_ASSERT_EQUAL(flags, DFQF_QUERY_RESIZED);

        UNIT_ASSERT(FilterAutoCampaignQuery("query1 * query2", filteredQuery, flags));
        UNIT_ASSERT_EQUAL(filteredQuery, "query1 query2");
        UNIT_ASSERT_EQUAL(flags, DFQF_REMOVED_SYMBOLS);
    }
}
