#include <library/cpp/testing/unittest/registar.h>

#include <wmconsole/version3/protos/querygroups.pb.h>

#include "batch_matcher.h"
#include "batch_matcher.cpp"

using namespace NWebmaster;
using namespace NWebmaster::proto::querygroups;

Y_UNIT_TEST_SUITE(TSearchQueriesMRTest2) {
    Y_UNIT_TEST(BatchMatcher_TBatchMatcher_Test01) {
        HostGroupInfo groupInfo;

        UNIT_ASSERT_EQUAL(TBatchMatcher(groupInfo).Matches("test_query"), false);

        groupInfo.add_queries()->set_text("test_query1");
        groupInfo.add_queries()->set_text("test_query2");
        groupInfo.add_queries()->set_text("запрос");
        groupInfo.add_queries()->set_text("|().*+?^$\\{}[]~");

        TString gen1;
        for (wchar16 i = 0x0000; i < 0x1000; i++) {
            wchar16 buf[2];
            buf[0] = i;
            buf[1] = 0;
            gen1.append(WideToUTF8(buf));
        }

        groupInfo.add_queries()->set_text(gen1);

        TString gen2;
        TString match2;

        for (wchar16 i = 0xF000; i < 0xFFFF; i++) {
            wchar16 buf[2];
            buf[0] = i;
            buf[1] = 0;
            gen2.append(WideToUTF8(buf));

            buf[0] = i & 0xFFF;
            match2.append(WideToUTF8(buf));
        }

        groupInfo.add_queries()->set_text(gen2);

        TBatchMatcher matcher(groupInfo);
        UNIT_ASSERT_EQUAL(matcher.Matches("test_query1"), true);
        UNIT_ASSERT_EQUAL(matcher.Matches("test_query2"), true);
        UNIT_ASSERT_EQUAL(matcher.Matches("запрос"), true);
        UNIT_ASSERT_EQUAL(matcher.Matches("|().*+?^$\\{}[]~"), true);
        UNIT_ASSERT_EQUAL(matcher.Matches("wrong_query"), false);
        UNIT_ASSERT_EQUAL(matcher.Matches(gen1), true);
        UNIT_ASSERT_EQUAL(matcher.Matches(match2), true);
    }
}
